/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.wallet.decryption;

import network.arkane.provider.secret.generation.EthereumSecretKey;
import network.arkane.provider.wallet.decryption.WalletDecryptor;
import network.arkane.provider.wallet.generation.GeneratedEthereumWallet;
import org.springframework.stereotype.Component;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;

@Component
public class EthereumWalletDecryptor
implements WalletDecryptor<GeneratedEthereumWallet, EthereumSecretKey> {
    public EthereumSecretKey generateKey(GeneratedEthereumWallet generatedWallet, String password) {
        try {
            ECKeyPair keyPair = Wallet.decrypt((String)password, (WalletFile)generatedWallet.getWalletFile());
            return EthereumSecretKey.builder().keyPair(keyPair).build();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to fetch wallet");
        }
    }
}

