/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.wallet.extraction;

import network.arkane.provider.secret.generation.EthereumSecretKey;
import network.arkane.provider.wallet.domain.SecretKey;
import network.arkane.provider.wallet.extraction.SecretExtractor;
import network.arkane.provider.wallet.extraction.request.EthereumPrivateKeyExtractionRequest;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.web3j.crypto.ECKeyPair;

@Component
public class EthereumPrivateKeyExtractor
implements SecretExtractor<EthereumPrivateKeyExtractionRequest> {
    private static final Logger log = LoggerFactory.getLogger(EthereumPrivateKeyExtractor.class);

    public SecretKey extract(EthereumPrivateKeyExtractionRequest importWalletRequest) {
        try {
            String sanitizedKey = this.sanitize(importWalletRequest.getPrivateKey());
            return EthereumSecretKey.builder().keyPair(ECKeyPair.create((byte[])Hex.decodeHex((String)sanitizedKey))).build();
        }
        catch (Exception ex) {
            log.error("Unable to decode ethereum private key {}", (Object)importWalletRequest.getPrivateKey());
            throw new IllegalArgumentException("Unable to decode ethereum private key " + importWalletRequest.getPrivateKey());
        }
    }

    private String sanitize(String privateKey) {
        if (privateKey != null && privateKey.startsWith("0x")) {
            return privateKey.substring(2);
        }
        return privateKey;
    }

    public Class<EthereumPrivateKeyExtractionRequest> getImportRequestType() {
        return EthereumPrivateKeyExtractionRequest.class;
    }
}

