/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.token;

import java.math.BigInteger;
import java.util.Optional;
import network.arkane.provider.chain.SecretType;
import network.arkane.provider.gateway.Web3JGateway;
import network.arkane.provider.token.NativeTokenDiscoveryService;
import network.arkane.provider.token.TokenInfo;
import org.springframework.stereotype.Component;

@Component
public class NativeEthereumTokenDiscoveryService
implements NativeTokenDiscoveryService {
    private Web3JGateway web3JGateway;

    public NativeEthereumTokenDiscoveryService(Web3JGateway web3JGateway) {
        this.web3JGateway = web3JGateway;
    }

    public Optional<TokenInfo> getTokenInfo(String tokenAddress) {
        String name = this.web3JGateway.getName(tokenAddress);
        String symbol = this.web3JGateway.getSymbol(tokenAddress);
        BigInteger decimals = this.web3JGateway.getDecimals(tokenAddress);
        if (name != null && decimals != null && symbol != null) {
            return Optional.of(TokenInfo.builder().address(tokenAddress).name(name).decimals(Integer.valueOf(decimals.intValue())).symbol(symbol).type("ERC20").build());
        }
        return Optional.empty();
    }

    public SecretType type() {
        return SecretType.ETHEREUM;
    }
}

