/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.contract;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import network.arkane.provider.BytesUtils;
import network.arkane.provider.Prefix;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;

public final class HumanStandardToken
extends Contract {
    private static final Credentials DUMMY = Credentials.create((String)"0x0");

    private HumanStandardToken(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super("", contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    public RemoteCall<String> name() {
        Function function = new Function("name", Collections.emptyList(), Collections.singletonList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> approve(String _spender, BigInteger _value) {
        Function function = new Function("approve", Arrays.asList(new Address(_spender), new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> totalSupply() {
        Function function = new Function("totalSupply", Collections.emptyList(), Collections.singletonList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> transferFrom(String _from, String _to, BigInteger _value) {
        Function function = new Function("transferFrom", Arrays.asList(new Address(_from), new Address(_to), new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> decimals() {
        Function function = new Function("decimals", Collections.emptyList(), Collections.singletonList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<String> version() {
        Function function = new Function("version", Collections.emptyList(), Collections.singletonList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<BigInteger> balanceOf(String _owner) {
        Function function = new Function("balanceOf", Collections.singletonList(new Address(_owner)), Collections.singletonList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<String> symbol() {
        Function function = new Function("symbol", Collections.emptyList(), Collections.singletonList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> transfer(String _to, BigInteger _value) {
        Function function = new Function("transfer", Arrays.asList(new Address(_to), new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> approveAndCall(String _spender, BigInteger _value, byte[] _extraData) {
        Function function = new Function("approveAndCall", Arrays.asList(new Address(_spender), new Uint256(_value), new DynamicBytes(_extraData)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> allowance(String _owner, String _spender) {
        Function function = new Function("allowance", Arrays.asList(new Address(_owner), new Address(_spender)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public static HumanStandardToken load(String contractAddress, Web3j web3j) {
        return new HumanStandardToken(BytesUtils.withHexPrefix((String)contractAddress, (Prefix)Prefix.ZeroLowerX), web3j, DUMMY, BigInteger.ZERO, BigInteger.ZERO);
    }
}

