/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.sign;

import network.arkane.provider.JSONUtil;
import network.arkane.provider.exceptions.ArkaneException;
import network.arkane.provider.secret.generation.EthereumSecretKey;
import network.arkane.provider.sign.EthereumRawSignable;
import network.arkane.provider.sign.Signer;
import network.arkane.provider.sign.domain.HexSignature;
import network.arkane.provider.sign.domain.Signature;
import network.arkane.provider.wallet.decryption.EthereumWalletDecryptor;
import network.arkane.provider.wallet.generation.GeneratedEthereumWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Sign;
import org.web3j.crypto.WalletFile;

@Component
public class EthereumRawSigner
implements Signer<EthereumRawSignable, EthereumSecretKey> {
    private static final Logger log = LoggerFactory.getLogger(EthereumRawSigner.class);
    private EthereumWalletDecryptor ethereumKeystoreExtractor;

    public EthereumRawSigner(EthereumWalletDecryptor ethereumKeystoreExtractor) {
        this.ethereumKeystoreExtractor = ethereumKeystoreExtractor;
    }

    public Signature createSignature(EthereumRawSignable signable, EthereumSecretKey key) {
        try {
            Sign.SignatureData signatureData = Sign.signMessage((byte[])signable.getData().getBytes("UTF-8"), (ECKeyPair)key.getKeyPair());
            return HexSignature.builder().r(signatureData.getR()).s(signatureData.getS()).v((int)signatureData.getV()).build();
        }
        catch (Exception ex) {
            log.error("Unable to sign transaction: {}", (Object)ex.getMessage());
            throw ArkaneException.arkaneException().errorCode("transaction.sign.internal-error").errorCode("A problem occurred trying to sign the raw Ethereum object").cause((Throwable)ex).build();
        }
    }

    public EthereumSecretKey reconstructKey(String secret, String password) {
        return this.ethereumKeystoreExtractor.generateKey(GeneratedEthereumWallet.builder().walletFile((WalletFile)JSONUtil.fromJson((String)secret, WalletFile.class)).build(), password);
    }

    public Class<EthereumRawSignable> getType() {
        return EthereumRawSignable.class;
    }
}

