/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.gateway;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import network.arkane.provider.contract.DeltaBalances;
import network.arkane.provider.contract.HumanStandardToken;
import network.arkane.provider.exceptions.ArkaneException;
import network.arkane.provider.gas.EthereumEstimateGasResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;
import org.web3j.ens.EnsResolver;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.EthEstimateGas;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthSendTransaction;

@Component
public class Web3JGateway {
    private static final Logger log = LoggerFactory.getLogger(Web3JGateway.class);
    private static final BigInteger DEFAULT_GAS_LIMIT_FAILED = new BigInteger("200000");
    private final EnsResolver ensResolver;
    private Web3j web3j;
    private DeltaBalances deltaBalances;

    public Web3JGateway(Web3j web3j, @Value(value="${network.arkane.ethereum.deltabalances.contract-address}") String deltaBalancesAddress) {
        this.web3j = web3j;
        this.ensResolver = new EnsResolver(this.web3j);
        this.deltaBalances = new DeltaBalances(deltaBalancesAddress, web3j);
    }

    public Web3j web3() {
        return this.web3j;
    }

    public EthGetBalance getBalance(String account) {
        try {
            return (EthGetBalance)this.web3().ethGetBalance(account, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
        }
        catch (Exception ex) {
            log.error("Problem trying to get balance from the Ethereum network");
            throw ArkaneException.arkaneException().errorCode("web3j.internal-error").message(String.format("Unable to get the balance for the specified account (%s) (Ethereum)", account)).build();
        }
    }

    @Cacheable(value={"address_to_ens"}, key="#address")
    public Optional<String> getEnsName(String address) {
        try {
            return Optional.ofNullable(this.ensResolver.reverseResolve(address));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    @Cacheable(value={"ens_to_address"}, key="#ensName")
    public Optional<String> getAddressForEnsName(String ensName) {
        try {
            return Optional.ofNullable(this.ensResolver.resolve(ensName));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public List<BigInteger> getTokenBalances(String owner, List<String> tokenAddress) {
        try {
            return this.deltaBalances.tokenBalances(owner, tokenAddress);
        }
        catch (Exception ex) {
            log.error(String.format("Problem trying to get the token balances of %s", owner), (Throwable)ex);
            throw ArkaneException.arkaneException().errorCode("web3j.internal-error").message(String.format("Problem trying to get the token balances of %s (Ethereum)", owner)).build();
        }
    }

    public BigInteger getTokenBalance(String owner, String tokenAddress) {
        try {
            return (BigInteger)this.getERC20(tokenAddress).balanceOf(owner).send();
        }
        catch (Exception ex) {
            log.error(String.format("Problem trying to get the token balance of %s for token %s", owner, tokenAddress), (Throwable)ex);
            throw ArkaneException.arkaneException().errorCode("web3j.internal-error").message(String.format("Problem trying to get the token balance of %s for token %s (Ethereum)", owner, tokenAddress)).build();
        }
    }

    public EthereumEstimateGasResult estimateGas(String from, String to, BigInteger value, String data) {
        try {
            BigInteger blockGasLimit = ((EthBlock)this.web3j.ethGetBlockByNumber((DefaultBlockParameter)DefaultBlockParameterName.LATEST, false).send()).getBlock().getGasLimit();
            Transaction transaction = Transaction.createFunctionCallTransaction((String)from, (BigInteger)BigInteger.ZERO, (BigInteger)BigInteger.ONE, (BigInteger)blockGasLimit, (String)to, (BigInteger)value, (String)data);
            EthEstimateGas ethEstimateGas = (EthEstimateGas)this.web3().ethEstimateGas(transaction).send();
            if (ethEstimateGas.hasError()) {
                return EthereumEstimateGasResult.builder().gasLimit(DEFAULT_GAS_LIMIT_FAILED).reverted(true).build();
            }
            BigInteger amountUsed = ethEstimateGas.getAmountUsed();
            return EthereumEstimateGasResult.builder().gasLimit(amountUsed).reverted(amountUsed.compareTo(blockGasLimit) >= 0).build();
        }
        catch (IOException e) {
            throw ArkaneException.arkaneException().errorCode("web3j.estimate.gas.internal-error").message("A problem occurred trying to estimate the gas.").cause((Throwable)e).build();
        }
    }

    public BigInteger getNextNonce(String address) {
        EthGetTransactionCount ethGetTransactionCount;
        try {
            ethGetTransactionCount = (EthGetTransactionCount)this.web3j.ethGetTransactionCount(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).sendAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw ArkaneException.arkaneException().errorCode("web3j.nonce.internal-error").message("A problem occurred trying to get the next nonce").cause((Throwable)e).build();
        }
        return ethGetTransactionCount.getTransactionCount();
    }

    public EthSendTransaction ethSendRawTransaction(String signedTransaction) {
        try {
            return (EthSendTransaction)this.web3().ethSendRawTransaction(signedTransaction).send();
        }
        catch (Exception ex) {
            log.error("Problem trying to submit transaction to the Ethereum network: {}", (Object)ex.getMessage());
            throw ArkaneException.arkaneException().errorCode("web3j.transaction.submit.internal-error").message("A problem occurred trying to submit the transaction to the Ethereum network").cause((Throwable)ex).build();
        }
    }

    public String getName(String tokenAddress) {
        try {
            return (String)this.getERC20(tokenAddress).name().send();
        }
        catch (Exception ex) {
            log.error(String.format("Problem trying to get the name for token %s (Ethereum)", tokenAddress), (Throwable)ex);
            throw ArkaneException.arkaneException().errorCode("web3j.internal-error").message(String.format("Problem trying to get the name for token %s (Ethereum)", tokenAddress)).build();
        }
    }

    public String getSymbol(String tokenAddress) {
        try {
            return (String)this.getERC20(tokenAddress).symbol().send();
        }
        catch (Exception ex) {
            log.error(String.format("Problem trying to get the symbol for token %s (Ethereum)", tokenAddress), (Throwable)ex);
            throw ArkaneException.arkaneException().errorCode("web3j.internal-error").message(String.format("Problem trying to get the symbol for token %s (Ethereum)", tokenAddress)).build();
        }
    }

    public BigInteger getDecimals(String tokenAddress) {
        try {
            return (BigInteger)this.getERC20(tokenAddress).decimals().send();
        }
        catch (Exception ex) {
            log.error(String.format("Problem trying to get the decimals for token %s (Ethereum)", tokenAddress), (Throwable)ex);
            throw ArkaneException.arkaneException().errorCode("web3j.internal-error").message(String.format("Problem trying to get the decimals for token %s (Ethereum)", tokenAddress)).build();
        }
    }

    private HumanStandardToken getERC20(String token) {
        return HumanStandardToken.load(token, this.web3());
    }
}

