/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.bridge;

import network.arkane.provider.bridge.TransactionGateway;
import network.arkane.provider.chain.SecretType;
import network.arkane.provider.exceptions.ArkaneException;
import network.arkane.provider.gateway.Web3JGateway;
import network.arkane.provider.sign.domain.Signature;
import network.arkane.provider.sign.domain.SubmittedAndSignedTransactionSignature;
import network.arkane.provider.sign.domain.TransactionSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.web3j.protocol.core.methods.response.EthSendTransaction;

@Service
public class EthereumTransactionGateway
implements TransactionGateway {
    private static final Logger log = LoggerFactory.getLogger(EthereumTransactionGateway.class);
    private Web3JGateway web3j;

    public EthereumTransactionGateway(Web3JGateway web3j) {
        this.web3j = web3j;
    }

    public SecretType getType() {
        return SecretType.ETHEREUM;
    }

    public Signature submit(TransactionSignature signTransactionResponse) {
        try {
            log.debug("Sending transaction to ethereum node {}", (Object)signTransactionResponse.getSignedTransaction());
            EthSendTransaction send = this.web3j.ethSendRawTransaction(signTransactionResponse.getSignedTransaction());
            if (send.hasError()) {
                if (send.getError().getMessage().contains("Insufficient funds")) {
                    log.debug("Got error from ethereum chain: insufficient funds");
                    throw ArkaneException.arkaneException().errorCode("transaction.insufficient-funds").message("The account that initiated the transfer does not have enough energy").build();
                }
                log.debug("Got error from ethereum chain: {}", (Object)send.getError().getMessage());
                throw ArkaneException.arkaneException().errorCode("transaction.submit.ethereum-error").message(send.getError().getMessage()).build();
            }
            log.debug("Updating last nonce");
            return SubmittedAndSignedTransactionSignature.signAndSubmitTransactionBuilder().transactionHash(send.getTransactionHash()).signedTransaction(signTransactionResponse.getSignedTransaction()).build();
        }
        catch (ArkaneException ex) {
            log.debug("Exception submitting transaction", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("Error trying to submit a signed transaction: {}", (Object)ex.getMessage());
            throw ArkaneException.arkaneException().errorCode("transaction.submit.internal-error").message("A problem occurred trying to submit the transaction to the Ethereum network").cause((Throwable)ex).build();
        }
    }
}

