/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.sign;

import java.math.BigInteger;
import network.arkane.provider.BytesUtils;
import network.arkane.provider.JSONUtil;
import network.arkane.provider.Prefix;
import network.arkane.provider.secret.generation.EthereumSecretKey;
import network.arkane.provider.sign.EthereumTransactionSignable;
import network.arkane.provider.sign.Signer;
import network.arkane.provider.sign.domain.Signature;
import network.arkane.provider.sign.domain.TransactionSignature;
import network.arkane.provider.wallet.decryption.EthereumWalletDecryptor;
import network.arkane.provider.wallet.generation.GeneratedEthereumWallet;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.stereotype.Component;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.crypto.WalletFile;

@Component
public class EthereumTransactionSigner
implements Signer<EthereumTransactionSignable, EthereumSecretKey> {
    private static final String DEFAULT_DATA = "0x";
    private EthereumWalletDecryptor ethereumKeystoreExtractor;

    public EthereumTransactionSigner(EthereumWalletDecryptor ethereumKeystoreExtractor) {
        this.ethereumKeystoreExtractor = ethereumKeystoreExtractor;
    }

    public Signature createSignature(EthereumTransactionSignable signable, EthereumSecretKey key) {
        RawTransaction rawTransaction = this.constructTransaction(signable);
        byte[] encodedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)Credentials.create((ECKeyPair)key.getKeyPair()));
        String prettify = BytesUtils.withHexPrefix((String)Hex.toHexString((byte[])encodedMessage), (Prefix)Prefix.ZeroLowerX);
        return TransactionSignature.signTransactionBuilder().signedTransaction(prettify).build();
    }

    public EthereumSecretKey reconstructKey(String secret, String password) {
        return this.ethereumKeystoreExtractor.generateKey(GeneratedEthereumWallet.builder().walletFile((WalletFile)JSONUtil.fromJson((String)secret, WalletFile.class)).build(), password);
    }

    public Class<EthereumTransactionSignable> getType() {
        return EthereumTransactionSignable.class;
    }

    private RawTransaction constructTransaction(EthereumTransactionSignable signTransactionRequest) {
        return RawTransaction.createTransaction((BigInteger)signTransactionRequest.getNonce(), (BigInteger)signTransactionRequest.getGasPrice(), (BigInteger)signTransactionRequest.getGasLimit(), (String)signTransactionRequest.getTo(), (BigInteger)signTransactionRequest.getValue(), (String)(StringUtils.isBlank((CharSequence)signTransactionRequest.getData()) ? DEFAULT_DATA : signTransactionRequest.getData()));
    }
}

