/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.balance;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import network.arkane.provider.PrecisionUtil;
import network.arkane.provider.balance.BalanceGateway;
import network.arkane.provider.balance.domain.Balance;
import network.arkane.provider.balance.domain.TokenBalance;
import network.arkane.provider.chain.SecretType;
import network.arkane.provider.exceptions.ArkaneException;
import network.arkane.provider.gateway.Web3JGateway;
import network.arkane.provider.token.TokenDiscoveryService;
import network.arkane.provider.token.TokenInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EthereumBalanceGateway
implements BalanceGateway {
    private static final Logger log = LoggerFactory.getLogger(EthereumBalanceGateway.class);
    private Web3JGateway web3JGateway;
    private final TokenDiscoveryService tokenDiscoveryService;

    public EthereumBalanceGateway(Web3JGateway web3JGateway, TokenDiscoveryService tokenDiscoveryService) {
        this.web3JGateway = web3JGateway;
        this.tokenDiscoveryService = tokenDiscoveryService;
    }

    public SecretType type() {
        return SecretType.ETHEREUM;
    }

    public Optional<TokenInfo> getTokenInfo(String tokenAddress) {
        String name = this.web3JGateway.getName(tokenAddress);
        String symbol = this.web3JGateway.getSymbol(tokenAddress);
        BigInteger decimals = this.web3JGateway.getDecimals(tokenAddress);
        if (name != null && decimals != null && symbol != null) {
            return Optional.of(TokenInfo.builder().address(tokenAddress).name(name).decimals(Integer.valueOf(decimals.intValue())).symbol(symbol).type("ERC20").build());
        }
        return Optional.empty();
    }

    public Balance getBalance(String account) {
        try {
            BigInteger balance = this.web3JGateway.getBalance(account).getBalance();
            return Balance.builder().rawBalance(balance.toString()).rawGasBalance(balance.toString()).secretType(SecretType.ETHEREUM).gasBalance(PrecisionUtil.toDecimal((BigInteger)balance, (int)18)).balance(PrecisionUtil.toDecimal((BigInteger)balance, (int)18)).symbol("ETH").gasSymbol("ETH").decimals(18).build();
        }
        catch (Exception ex) {
            throw ArkaneException.arkaneException().message(String.format("Unable to get the balance for the specified account (%s)", account)).errorCode("web3.internal-error").build();
        }
    }

    public TokenBalance getTokenBalance(String walletAddress, String tokenAddress) {
        TokenInfo tokenInfo = (TokenInfo)this.tokenDiscoveryService.getTokenInfo(SecretType.ETHEREUM, tokenAddress).orElseThrow(IllegalArgumentException::new);
        return this.getTokenBalance(walletAddress, tokenInfo);
    }

    private TokenBalance getTokenBalance(String walletAddress, TokenInfo tokenInfo) {
        BigInteger tokenBalance = this.web3JGateway.getTokenBalance(walletAddress, tokenInfo.getAddress());
        return TokenBalance.builder().tokenAddress(tokenInfo.getAddress()).rawBalance(tokenBalance.toString()).balance(this.calculateBalance(tokenBalance, tokenInfo)).decimals(tokenInfo.getDecimals().intValue()).symbol(tokenInfo.getSymbol()).logo(tokenInfo.getLogo()).build();
    }

    public List<TokenBalance> getTokenBalances(String walletAddress) {
        return this.getTokenBalances(walletAddress, this.tokenDiscoveryService.getTokens(SecretType.ETHEREUM));
    }

    private List<TokenBalance> getTokenBalances(String walletAddress, List<TokenInfo> tokenInfo) {
        List<BigInteger> balances = this.web3JGateway.getTokenBalances(walletAddress, tokenInfo.stream().map(x -> x.getAddress()).collect(Collectors.toList()));
        ArrayList<TokenBalance> results = new ArrayList<TokenBalance>();
        for (int i = 0; i < balances.size(); ++i) {
            TokenInfo token = tokenInfo.get(i);
            results.add(TokenBalance.builder().tokenAddress(token.getAddress()).rawBalance(balances.get(i).toString()).balance(this.calculateBalance(balances.get(i), token)).decimals(token.getDecimals().intValue()).symbol(token.getSymbol()).logo(token.getLogo()).build());
        }
        return results;
    }

    private double calculateBalance(BigInteger tokenBalance, TokenInfo tokenInfo) {
        BigDecimal rawBalance = new BigDecimal(tokenBalance);
        BigDecimal divider = BigDecimal.valueOf(10L).pow(tokenInfo.getDecimals());
        return rawBalance.divide(divider, 6, RoundingMode.HALF_DOWN).doubleValue();
    }
}

