/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.wallet.extraction;

import network.arkane.provider.JSONUtil;
import network.arkane.provider.secret.generation.EthereumSecretKey;
import network.arkane.provider.wallet.domain.SecretKey;
import network.arkane.provider.wallet.extraction.AbstractSecretExtractor;
import network.arkane.provider.wallet.extraction.request.KeystoreExtractionRequest;
import org.springframework.stereotype.Component;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;

@Component
public class EthereumKeystoreExtractor
implements AbstractSecretExtractor<KeystoreExtractionRequest> {
    public SecretKey extract(KeystoreExtractionRequest importWalletRequest) {
        try {
            WalletFile walletFile = (WalletFile)JSONUtil.fromJson((String)importWalletRequest.getKeystore(), WalletFile.class);
            ECKeyPair keypair = Wallet.decrypt((String)importWalletRequest.getPassword(), (WalletFile)walletFile);
            return EthereumSecretKey.builder().keyPair(keypair).build();
        }
        catch (Exception ex) {
            String msg = "Not a valid keystore file";
            if (ex.getMessage() != null && ex.getMessage().contains("Invalid password provided")) {
                msg = "Wrong password provided for given keystore file";
            }
            throw new IllegalArgumentException(msg);
        }
    }

    public Class<KeystoreExtractionRequest> getImportRequestType() {
        return KeystoreExtractionRequest.class;
    }
}

