/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.bridge;

import java.math.BigInteger;
import java.util.Optional;
import network.arkane.provider.bridge.BlockchainBridge;
import network.arkane.provider.chain.SecretType;
import network.arkane.provider.exceptions.ArkaneException;
import network.arkane.provider.gateway.Web3JGateway;
import network.arkane.provider.signature.Signature;
import network.arkane.provider.signature.SubmittedAndSignedTransactionSignature;
import network.arkane.provider.signature.TransactionSignature;
import network.arkane.provider.token.TokenInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.web3j.protocol.core.methods.response.EthSendTransaction;

@Service
public class EthereumBridge
implements BlockchainBridge {
    private static final Logger log = LoggerFactory.getLogger(EthereumBridge.class);
    private Web3JGateway web3j;
    private ApplicationEventPublisher applicationEventPublisher;

    public EthereumBridge(Web3JGateway web3j, ApplicationEventPublisher applicationEventPublisher) {
        this.web3j = web3j;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public SecretType getType() {
        return SecretType.ETHEREUM;
    }

    public Signature submit(TransactionSignature signTransactionResponse) {
        try {
            log.debug("Sending transaction to ethereum node {}", (Object)signTransactionResponse.getSignedTransaction());
            EthSendTransaction send = this.web3j.ethSendRawTransaction(signTransactionResponse.getSignedTransaction());
            if (send.hasError()) {
                if (send.getError().getMessage().contains("Insufficient funds")) {
                    log.debug("Got error from ethereum chain: insufficient funds");
                    throw ArkaneException.arkaneException().errorCode("transaction.insufficient-funds").message("The account that initiated the transfer does not have enough energy").build();
                }
                log.debug("Got error from ethereum chain: {}", (Object)send.getError().getMessage());
                throw ArkaneException.arkaneException().errorCode("transaction.submit.ethereum-error").message(send.getError().getMessage()).build();
            }
            log.debug("Updating last nonce");
            return SubmittedAndSignedTransactionSignature.signAndSubmitTransactionBuilder().transactionHash(send.getTransactionHash()).signedTransaction(signTransactionResponse.getSignedTransaction()).build();
        }
        catch (ArkaneException ex) {
            log.debug("Exception submitting transaction", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("Error trying to submit a signed transaction: {}", (Object)ex.getMessage());
            throw ArkaneException.arkaneException().errorCode("transaction.submit.internal-error").message("A problem occurred trying to submit the transaction to the Ethereum network").cause((Throwable)ex).build();
        }
    }

    public Optional<TokenInfo> getTokenInfo(String tokenAddress) {
        String name = this.web3j.getName(tokenAddress);
        String symbol = this.web3j.getSymbol(tokenAddress);
        BigInteger decimals = this.web3j.getDecimals(tokenAddress);
        if (name != null && decimals != null && symbol != null) {
            return Optional.of(TokenInfo.builder().address(tokenAddress).name(name).decimals(Integer.valueOf(decimals.intValue())).symbol(symbol).type("ERC20").build());
        }
        return Optional.empty();
    }
}

