package org.graphstream.ui.swing.renderer.shape.swing;

import org.graphstream.ui.swing.Backend;

import java.awt.*;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class SwingTextBox extends TextBox {

    public int maxWidth = 190;
    Font font;
    Color textColor;
    Color bgColor;
    boolean rounded;
    double padx;
    double pady;

    JMultilineLabel text;
    Rectangle2D bounds;

    public SwingTextBox(Font font, Color textColor, Color bgColor, boolean rounded, double padx, double pady) {
        this.font = font;
        this.textColor = textColor;
        this.bgColor = bgColor;
        this.rounded = rounded;
        this.padx = padx;
        this.pady = pady;

        this.text = null;
        this.textData = null;
        this.bounds = new Rectangle2D.Double(0, 0, 0, 0);
    }


    /**
     * Changes the text and compute its bounds. This method tries to avoid recomputing bounds
     * if the text does not really changed.
     */
    public void setText(String text, Backend backend) {
        if (text != null && text.length() > 0) {
            if (textData != text || !textData.equals(text)) {
                // As the text is not rendered using the default affine transform, but using
                // the identity transform, and as the FontRenderContext uses the current
                // transform, we use a predefined default font render context initialized
                // with an identity transform here.
                this.textData = text;
                if(text.equalsIgnoreCase("PositiveFeedbackSynapse")) {
                    maxWidth = 180;
                }

                this.text = new JMultilineLabel(text, font, TextBox.defaultFontRenderContext, maxWidth);
                this.bounds = this.text.getBounds();
            } else {
                this.textData = null;
                this.text = null;
                this.bounds = new Rectangle2D.Double(0, 0, 0, 0);
            }
        }
    }

    @Override
    public String getText() {
        return textData;
    }

    public double getWidth() {
        if (bounds != null)
            return bounds.getWidth();
        else
            return 0;
    }

    public double getHeight() {
        if (bounds != null)
            return bounds.getHeight();
        else
            return 0;
    }

    public double getDescent() {
        if (text != null)
            return 0; //text.getDescent() ;
        else
            return 0;
    }

    public double getAscent() {
        if (text != null)
            return 0; // text.getAscent() ;
        else
            return 0;
    }

    public void render(Backend backend, double xLeft, double yBottom) {

        if (text != null) {
            Graphics2D g = backend.graphics2D();

            if (bgColor != null) {
                g.setColor(bgColor);
                if (rounded) {
                    g.fill(new RoundRectangle2D.Double(xLeft - padx, yBottom - (pady), getWidth() + 1 + (padx + padx), getHeight() + 1 + (pady + pady), 6, 6));
                } else {
                    g.fill(new Rectangle2D.Double(xLeft - padx, yBottom - (pady), getWidth() + 1 + (padx + padx), getHeight() + 1 + (pady + pady)));
                }
            }
            g.setColor(textColor);
            text.draw(g, (float) xLeft, (float) yBottom, text.getMaxWidth());
        }
    }
}
