/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.neurons.renderer;

import javax.swing.text.StyledDocument;
import network.aika.debugger.AbstractConsole;
import network.aika.debugger.ConsoleRenderer;
import network.aika.neuron.Neuron;
import network.aika.neuron.Range;
import network.aika.neuron.activation.Activation;
import network.aika.sign.Sign;
import network.aika.utils.Utils;

public class NeuronConsoleRenderer<E extends Neuron>
implements ConsoleRenderer<E> {
    protected Activation ref;

    public NeuronConsoleRenderer(Activation ref) {
        this.ref = ref;
    }

    @Override
    public void render(StyledDocument sDoc, E n) {
        this.appendText(sDoc, (n.isTemplate() ? "Template " : "") + n.getClass().getSimpleName() + "\n", "headline");
        this.appendEntry(sDoc, "Id: ", "" + n.getId());
        this.appendEntry(sDoc, "Label: ", n.getLabel());
        if (n.isNetworkInput()) {
            this.appendEntry(sDoc, "Is Network Input Neuron: ", "" + n.isNetworkInput());
        }
        this.appendEntry(sDoc, "Bias: ", "" + n.getBias());
        Range range = !n.isTemplate() && this.ref != null ? this.ref.getAbsoluteRange() : null;
        this.appendEntry(sDoc, "Range: ", (String)(range != null ? "" + range : AbstractConsole.NOT_SET_STR));
        this.appendEntry(sDoc, "Frequency: ", "" + Utils.round((double)n.getFrequency()));
        this.appendEntry(sDoc, "SampleSpace: ", "" + n.getSampleSpace());
        this.appendEntry(sDoc, "P(POS): ", this.probabilityToString((Sign)Sign.POS, (Neuron)n, range));
        this.appendEntry(sDoc, "P(NEG): ", this.probabilityToString((Sign)Sign.NEG, (Neuron)n, range));
        this.appendEntry(sDoc, "Surprisal(POS): ", this.surprisalToString((Sign)Sign.POS, (Neuron)n, range));
        this.appendEntry(sDoc, "Surprisal(NEG): ", this.surprisalToString((Sign)Sign.NEG, (Neuron)n, range));
        this.appendEntry(sDoc, "Template Neuron: ", this.templatesToString((Neuron<?, ?>)n));
    }

    private String templatesToString(Neuron<?, ?> n) {
        StringBuilder sb = new StringBuilder();
        n.getTemplateGroup().forEach(tn -> sb.append(tn.getId() + ":" + tn.getLabel() + ", "));
        return sb.toString();
    }

    private String probabilityToString(Sign s, Neuron n, Range range) {
        double N = n.getSampleSpace().getN(range);
        if (N == 0.0) {
            return AbstractConsole.NOT_SET_STR;
        }
        try {
            return "" + Utils.round((double)n.getProbability(s, N, false), (double)1.0E8);
        }
        catch (IllegalStateException e) {
            return AbstractConsole.NOT_SET_STR;
        }
    }

    private String surprisalToString(Sign s, Neuron n, Range range) {
        double N = n.getSampleSpace().getN(range);
        if (N == 0.0) {
            return AbstractConsole.NOT_SET_STR;
        }
        try {
            return "" + Utils.round((double)n.getSurprisal(s, range, false));
        }
        catch (IllegalStateException e) {
            return AbstractConsole.NOT_SET_STR;
        }
    }
}

