/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.neurons;

import network.aika.Model;
import network.aika.debugger.AbstractLayout;
import network.aika.debugger.neurons.AbstractNeuronViewManager;
import network.aika.debugger.neurons.NeuronGraphManager;
import network.aika.debugger.neurons.NeuronParticle;
import network.aika.neuron.NeuronProvider;
import org.graphstream.graph.Node;
import org.graphstream.ui.layout.springbox.NodeParticle;
import org.miv.pherd.geom.Point3;

public class NeuronLayout
extends AbstractLayout<NeuronGraphManager> {
    AbstractNeuronViewManager nvm;

    public NeuronLayout(AbstractNeuronViewManager nvm, NeuronGraphManager gm) {
        super(gm);
        this.nvm = nvm;
        k = STANDARD_DISTANCE_X;
        K1Init = 0.06f;
        K1Final = 0.01f;
        this.K2 = 0.005f;
    }

    public NodeParticle newNodeParticle(String id) {
        Double y;
        Double x;
        Model model = this.nvm.getModel();
        Node n = ((NeuronGraphManager)this.graphManager).getNode(id);
        NeuronProvider np = model.lookupNeuron((Long)n.getAttribute("aika.neuronId", Long.class));
        Long originNeuronId = (Long)n.getAttribute("aika.originNeuronId", Long.class);
        if (originNeuronId != null) {
            NeuronParticle originParticle = (NeuronParticle)((Object)((NeuronGraphManager)this.graphManager).getParticle(originNeuronId));
            Point3 originPos = originParticle.getPosition();
            x = originPos.x;
            y = originPos.y + STANDARD_DISTANCE_Y;
        } else {
            x = (Double)n.getAttribute("x");
            y = (Double)n.getAttribute("y");
            if (x == null) {
                x = 0.0;
            }
            if (y == null) {
                y = 0.0;
            }
        }
        x = x + (this.random.nextDouble() - 0.5) * 0.1;
        y = y + (this.random.nextDouble() - 0.5) * 0.1;
        NeuronParticle particle = new NeuronParticle(this, id, np.getNeuron(), x, y, 0.0);
        ((NeuronGraphManager)this.graphManager).setParticle(np.getNeuron(), particle);
        return particle;
    }
}

