/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.neurons;

import network.aika.debugger.AbstractGraphManager;
import network.aika.debugger.neurons.NeuronParticle;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.conjunctive.ConjunctiveNeuron;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;

public class NeuronGraphManager
extends AbstractGraphManager<Neuron, Synapse, NeuronParticle> {
    public NeuronGraphManager(Graph graph) {
        super(graph);
    }

    @Override
    protected Long getAikaNodeId(Neuron n) {
        return n.getId();
    }

    @Override
    public Edge lookupEdge(Synapse s) {
        return this.lookupEdge(s.getInput(), s.getOutput());
    }

    @Override
    public Edge getEdge(Synapse s) {
        return this.getEdge(s.getInput(), s.getOutput());
    }

    @Override
    public Synapse getLink(Edge e) {
        Neuron in = (Neuron)this.getAikaNode(e.getSourceNode());
        Neuron on = (Neuron)this.getAikaNode(e.getTargetNode());
        if (on instanceof ConjunctiveNeuron) {
            return on.getInputSynapses().filter(s -> s.getInput() == in).findAny().orElse(null);
        }
        return in.getOutputSynapses().filter(s -> s.getOutput() == on).findAny().orElse(null);
    }
}

