/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.activations.renderer;

import javax.swing.text.StyledDocument;
import network.aika.Thought;
import network.aika.debugger.ConsoleRenderer;
import network.aika.neuron.activation.Timestamp;
import network.aika.steps.Step;

public class StepConsoleRenderer
implements ConsoleRenderer<Step> {
    private Thought t;

    public StepConsoleRenderer(Thought t) {
        this.t = t;
    }

    @Override
    public void render(StyledDocument sDoc, Step s) {
        Timestamp currentTimestamp = this.t.getTimestampOnProcess();
        String regularColor = "regular";
        String boldColor = "bold";
        if (currentTimestamp.compareTo(s.getSecondaryTimestamp()) <= 0) {
            regularColor = "regularGreen";
            boldColor = "boldGreen";
        }
        this.appendEntry(sDoc, StepConsoleRenderer.getQueueEntrySortKeyDescription(s), s.toString(), boldColor, regularColor);
    }

    public static String getQueueEntrySortKeyDescription(Step s) {
        return s.getPhase().name() + " " + s.timestampToString() + " " + s.getStepName() + " ";
    }
}

