/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.activations.renderer;

import javax.swing.text.StyledDocument;
import network.aika.debugger.ConsoleRenderer;
import network.aika.fields.FieldOutput;
import network.aika.neuron.activation.Activation;

public class ActivationConsoleRenderer<E extends Activation>
implements ConsoleRenderer<E> {
    @Override
    public void render(StyledDocument sDoc, E act) {
        this.appendText(sDoc, (act.isTemplate() ? "Template " : "") + act.getClass().getSimpleName() + " \n", "headline");
        this.appendEntry(sDoc, "Id: ", "" + act.getId());
        this.appendEntry(sDoc, "Label: ", act.getLabel());
        if (act.isInput()) {
            this.appendEntry(sDoc, "IsInput: ", "" + act.isInput());
        }
        this.appendField(sDoc, (FieldOutput)act.getValue());
        this.appendField(sDoc, act.getFinalValue());
        this.appendField(sDoc, (FieldOutput)act.getNet());
        if (act.getNetOuterGradient() != null) {
            this.appendField(sDoc, (FieldOutput)act.getNetOuterGradient());
        }
        this.appendField(sDoc, act.getIsFired());
        this.appendField(sDoc, act.getIsFiredForWeight());
        this.appendField(sDoc, act.getIsFiredForBias());
        this.appendField(sDoc, (FieldOutput)act.getIsFinal());
        this.appendField(sDoc, act.getEntropy());
        this.appendField(sDoc, (FieldOutput)act.getOwnInputGradient());
        this.appendField(sDoc, act.getOwnOutputGradient());
        this.appendField(sDoc, (FieldOutput)act.getBackpropInputGradient());
        this.appendField(sDoc, act.getBackpropOutputGradient());
        this.appendField(sDoc, act.getOutputGradient());
        this.appendField(sDoc, act.getUpdateValue());
        this.appendField(sDoc, act.getInductionThreshold());
        this.appendEntry(sDoc, "CreatedTS: ", "" + act.getCreated());
        this.appendEntry(sDoc, "FiredTS: ", "" + act.getFired());
    }
}

