/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.neurons;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.text.StyledDocument;
import network.aika.debugger.AbstractConsoleManager;
import network.aika.debugger.neurons.NeuronConsole;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;

public class NeuronConsoleManager
extends AbstractConsoleManager<NeuronConsole> {
    private JTabbedPane neuronViewTabbedPane;

    public NeuronConsoleManager() {
        super(new NeuronConsole(), new NeuronConsole());
    }

    private JComponent initActivationViewTabbedPane() {
        this.neuronViewTabbedPane = new JTabbedPane();
        this.neuronViewTabbedPane.setTabLayoutPolicy(1);
        this.neuronViewTabbedPane.setFocusCycleRoot(true);
        this.neuronViewTabbedPane.addTab("Main", null, NeuronConsoleManager.getScrollPane(this.mainConsole), "Shows the currently processed graph element");
        this.neuronViewTabbedPane.addTab("Selected", null, NeuronConsoleManager.getScrollPane(this.selectedConsole), "Shows the selected graph element");
        return this.neuronViewTabbedPane;
    }

    public void showSelectedElementContext(Neuron n) {
        this.neuronViewTabbedPane.setSelectedIndex(1);
        ((NeuronConsole)this.selectedConsole).render(sDoc -> ((NeuronConsole)this.selectedConsole).renderNeuronConsoleOutput((StyledDocument)sDoc, n, null));
    }

    public void showSelectedElementContext(Synapse s) {
        this.neuronViewTabbedPane.setSelectedIndex(1);
        ((NeuronConsole)this.selectedConsole).render(sDoc -> ((NeuronConsole)this.selectedConsole).renderSynapseConsoleOutput((StyledDocument)sDoc, s, null));
    }

    private static JScrollPane getScrollPane(Component c) {
        JScrollPane scrollPane = new JScrollPane(c);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setPreferredSize(new Dimension(250, 155));
        scrollPane.setMinimumSize(new Dimension(10, 10));
        return scrollPane;
    }

    @Override
    public JComponent getConsolePane() {
        return this.initActivationViewTabbedPane();
    }
}

