/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.neurons;

import java.util.function.Consumer;
import network.aika.Model;
import network.aika.debugger.AbstractViewManager;
import network.aika.debugger.neurons.NeuronConsoleManager;
import network.aika.debugger.neurons.NeuronGraphManager;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Node;

public abstract class AbstractNeuronViewManager
extends AbstractViewManager<Neuron, NeuronConsoleManager, NeuronGraphManager> {
    public AbstractNeuronViewManager(Model model, NeuronConsoleManager consoleManager) {
        super(model, consoleManager);
    }

    public abstract void updateGraphNeurons();

    protected void drawNeuron(Neuron<?, ?> n, double x, double y) {
        ((NeuronGraphManager)this.graphManager).lookupNode(n, node -> this.drawNeuron(n, x, y, (Node)node));
    }

    protected void drawNeuron(Neuron<?, ?> n, double x, double y, Node node) {
        double[] coords;
        node.setAttribute("aika.neuronId", new Object[]{n.getId()});
        Consumer neuronTypeModifier = (Consumer)this.neuronTypeModifiers.get(n.getClass());
        if (neuronTypeModifier != null) {
            neuronTypeModifier.accept(node);
        }
        node.setAttribute("ui.label", new Object[]{n.getLabel()});
        if (n.isTemplate()) {
            this.addTemplateAttributes((Element)node);
        }
        if (this.getCoordinateListener() != null && (coords = this.getCoordinateListener().getCoordinate(n)) != null) {
            node.setAttribute("x", new Object[]{coords[0]});
            node.setAttribute("y", new Object[]{coords[1]});
            return;
        }
        node.setAttribute("x", new Object[]{x});
        node.setAttribute("y", new Object[]{y});
    }

    protected void drawInputSynapses(Neuron<?, ?> n) {
        n.getInputSynapses().forEach(s -> this.drawSynapse((Synapse)s));
    }

    protected void drawOutputSynapsesLinkedOnlyOnTheInputSide(Neuron<?, ?> n) {
        n.getOutputSynapses().filter(s -> !s.isOutputLinked()).forEach(s -> this.drawSynapse((Synapse)s));
    }

    protected Edge drawSynapse(Synapse s) {
        if (((NeuronGraphManager)this.graphManager).getNode(s.getInput()) == null || ((NeuronGraphManager)this.graphManager).getNode(s.getOutput()) == null) {
            return null;
        }
        Edge edge = ((NeuronGraphManager)this.graphManager).lookupEdge(s);
        this.applyEdgeStyle(s, edge);
        return edge;
    }
}

