/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.activations.renderer;

import java.util.stream.Stream;
import javax.swing.text.StyledDocument;
import network.aika.Thought;
import network.aika.debugger.ConsoleRenderer;
import network.aika.debugger.activations.renderer.StepConsoleRenderer;
import network.aika.neuron.activation.Element;
import network.aika.steps.Step;

public class ElementQueueRenderer
implements ConsoleRenderer<Element> {
    private Step step;
    private String event;

    public ElementQueueRenderer(Step step, String event) {
        this.step = step;
        this.event = event;
    }

    @Override
    public void render(StyledDocument sDoc, Element e) {
        if (this.step != null) {
            this.appendText(sDoc, this.event + " " + this.step.getSecondaryTimestamp() + ":" + this.step.getClass().getSimpleName() + "\n", "headline");
        } else {
            this.appendText(sDoc, this.event + "\n", "headline");
        }
        Thought t = e.getThought();
        if (t == null) {
            return;
        }
        Stream elementQueue = t.getQueue().stream();
        elementQueue.filter(s -> s.getElement() == e).forEach(s -> new StepConsoleRenderer(e.getThought()).render(sDoc, (Step)s));
    }
}

