/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger;

import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import network.aika.debugger.AbstractConsole;
import network.aika.fields.Field;
import network.aika.fields.FieldOutput;
import network.aika.neuron.activation.Activation;

public interface ConsoleRenderer<E> {
    public void render(StyledDocument var1, E var2);

    default public void appendFieldWithReference(StyledDocument sDoc, Field f) {
        if (f != null) {
            this.appendEntry(sDoc, f.getLabel() + ": ", f + " (" + f.getReference() + ")");
        }
    }

    default public void appendField(StyledDocument sDoc, String prefix, FieldOutput f) {
        if (f != null) {
            this.appendEntry(sDoc, prefix + f.getLabel() + ": ", "" + f);
        }
    }

    default public void appendField(StyledDocument sDoc, FieldOutput f) {
        if (f != null) {
            this.appendEntry(sDoc, f.getLabel() + ": ", "" + f);
        }
    }

    default public void appendEntry(StyledDocument sDoc, String fieldName, String fieldValue) {
        this.appendEntry(sDoc, fieldName, fieldValue, "bold", "regular");
    }

    default public void appendEntry(StyledDocument sDoc, String fieldName, String fieldValue, String titleStyle, String style) {
        this.appendText(sDoc, fieldName, titleStyle);
        this.appendText(sDoc, fieldValue + "\n", style);
    }

    default public void appendText(StyledDocument sDoc, String txt, String style) {
        try {
            sDoc.insertString(sDoc.getLength(), txt, sDoc.getStyle(style));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    default public void addHeadline(StyledDocument sDoc, String headline) {
        this.appendText(sDoc, headline + "\n\n", "headline");
    }

    default public String getShortString(Activation act) {
        return act != null ? act.toString() : AbstractConsole.NOT_SET_STR;
    }
}

