/*
 * Decompiled with CFR 0.152.
 */
package net.lbruun.springboot.preliquibase.utils;

import java.sql.SQLException;
import javax.sql.DataSource;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import net.lbruun.springboot.preliquibase.PreLiquibaseException;

public class LiquibaseUtils {
    private LiquibaseUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getLiquibaseDatabaseShortName(DataSource dataSource) {
        try (JdbcConnection jdbcConnection = new JdbcConnection(dataSource.getConnection());){
            String string;
            block15: {
                Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)jdbcConnection);
                try {
                    string = database.getShortName();
                    if (database == null) break block15;
                }
                catch (Throwable throwable) {
                    if (database != null) {
                        try {
                            database.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                database.close();
            }
            return string;
        }
        catch (SQLException ex1) {
            throw new PreLiquibaseException.ResolveDbPlatformError("Could not acquire connection for DataSource", ex1);
        }
        catch (DatabaseException ex2) {
            throw new PreLiquibaseException.ResolveDbPlatformError("Error while finding Liquibase Database implementation for DataSource", ex2);
        }
        catch (Exception ex3) {
            throw new PreLiquibaseException.ResolveDbPlatformError("Unexpected error while finding Liquibase Database implementation for DataSource", ex3);
        }
    }
}

