/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;

abstract class PathMatcher {
    private static final PathMatcher EMPTY = new PathMatcher(){

        @Override
        boolean matches(String pathToMatch) {
            return false;
        }
    };

    PathMatcher() {
    }

    abstract boolean matches(String var1);

    static PathMatcher create(Set<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return EMPTY;
        }
        ArrayList<PathMatcher> matchers = new ArrayList<PathMatcher>(paths.size());
        for (String path : paths) {
            matchers.add(PathMatcher.create(path));
        }
        return new AggregatePathMatcher(matchers);
    }

    static PathMatcher create(String path) {
        if (path.contains("[*]")) {
            return new ArrayWildcardMatcher(path);
        }
        return new SimplePathMatcher(path);
    }

    private static class AggregatePathMatcher
    extends PathMatcher {
        private final Collection<PathMatcher> pathMatchers;

        private AggregatePathMatcher(Collection<PathMatcher> pathMatchers) {
            this.pathMatchers = pathMatchers;
        }

        @Override
        boolean matches(String path) {
            for (PathMatcher matcher : this.pathMatchers) {
                if (!matcher.matches(path)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ArrayWildcardMatcher
    extends PathMatcher {
        private final Pattern pattern;

        ArrayWildcardMatcher(String path) {
            int to;
            StringBuilder regexp = new StringBuilder();
            int from = 0;
            while ((to = path.indexOf("[*]", from)) >= 0) {
                regexp.append("\\Q").append(path.substring(from, to)).append("\\E").append("\\[\\d+\\]");
                from = to + 3;
            }
            if (from < path.length()) {
                regexp.append("\\Q").append(path.substring(from, path.length())).append("\\E");
            }
            this.pattern = Pattern.compile(regexp.toString());
        }

        @Override
        boolean matches(String pathToMatch) {
            return this.pattern.matcher(pathToMatch).matches();
        }
    }

    private static class SimplePathMatcher
    extends PathMatcher {
        private final String path;

        SimplePathMatcher(String path) {
            this.path = path;
        }

        @Override
        boolean matches(String pathToMatch) {
            return this.path.equals(pathToMatch);
        }
    }
}

