/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Node {
    public static final Node MISSING_NODE = new Node(){

        public boolean isArray() {
            return false;
        }

        @Override
        public Node element(int index) {
            return null;
        }

        @Override
        public Iterator<KeyValue> fields() {
            Set emptySet = Collections.emptySet();
            return emptySet.iterator();
        }

        @Override
        public Node get(String key) {
            return this;
        }

        @Override
        public boolean isMissingNode() {
            return true;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public Iterator<Node> arrayElements() {
            Set emptySet = Collections.emptySet();
            return emptySet.iterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public String asText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NodeType getNodeType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal decimalValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void ___do_not_implement_this_interface_seriously() {
        }
    };

    public Node element(int var1);

    public Iterator<KeyValue> fields();

    public Node get(String var1);

    public boolean isMissingNode();

    public boolean isNull();

    public Iterator<Node> arrayElements();

    public int size();

    public String asText();

    public NodeType getNodeType();

    public BigDecimal decimalValue();

    public Boolean asBoolean();

    public Object getValue();

    public void ___do_not_implement_this_interface_seriously();

    public static interface ValueExtractor {
        public Object getValue(Node var1);
    }

    public static class KeyValue {
        private final String key;
        private final Node value;

        public KeyValue(String key, Node value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Node getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeType implements ValueExtractor
    {
        OBJECT{

            public Object getValue(Node node) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                Iterator<KeyValue> fields = node.fields();
                while (fields.hasNext()) {
                    KeyValue keyValue = fields.next();
                    result.put(keyValue.getKey(), keyValue.getValue().getValue());
                }
                return Collections.unmodifiableMap(result);
            }
        }
        ,
        ARRAY{

            public Object getValue(Node node) {
                Iterator<Node> nodeIterator = node.arrayElements();
                LinkedList<Object> result = new LinkedList<Object>();
                while (nodeIterator.hasNext()) {
                    Node arrayNode = nodeIterator.next();
                    result.add(arrayNode.getValue());
                }
                return Collections.unmodifiableCollection(result);
            }
        }
        ,
        STRING{

            public Object getValue(Node node) {
                return node.asText();
            }
        }
        ,
        NUMBER{

            public Object getValue(Node node) {
                return node.decimalValue();
            }
        }
        ,
        BOOLEAN{

            public Object getValue(Node node) {
                return node.asBoolean();
            }
        }
        ,
        NULL{

            public Object getValue(Node node) {
                return null;
            }
        };

    }
}

