package com.trx.neon.beta;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by Dan on 1/26/2016.
 */
public class WeaponStatusEvent implements Parcelable, INeonEventBeta
{
    public final String type;
    public final String status;

    /** Represents a supported weapon status*/
    public enum WeaponStatusEventType
    {
        /**
         * indicates that the user has not selected a weapon
         * or the weapon is out of range
         */
        NO_WEAPON,
        /** indicates that the weapon is completely motionless (on ground) */
        ON_GROUND,
        /** indicates that the weapon is raised and aiming +/- 45 degrees
         *  of center relative to the user’s body */
        AIM_CENTER,
        /** indicates that the weapon is raised and aiming greater than 45 degrees
         *  to the left of center relative to the user’s body */
        AIM_LEFT,
        /** indicates that the weapon is raised and aiming greater than 45 degrees
         *  to the right of center relative to the user’s body */
        AIM_RIGHT,
        /** indicates that the weapon is not aiming */
        DEPLOYED
    }

    public WeaponStatusEventType getType()
    {
        try
        {
            return Enum.valueOf(WeaponStatusEventType.class, type);
        }
        catch (IllegalArgumentException e)
        {
            //Version mismatch with Neon Location Services?
            return null;
        }
    }



    public WeaponStatusEvent(String type, WeaponStatusEventType status)
    {
        this.type = type;
        this.status = status.name();
    }

    private WeaponStatusEvent(Parcel in)
    {
        this.type = in.readString();
        this.status = in.readString();
    }

    /**
     * Used for sending data across binders
     */
    public static final Parcelable.Creator<WeaponStatusEvent> CREATOR = new Parcelable.Creator<WeaponStatusEvent>() {
        @Override
        public WeaponStatusEvent createFromParcel(Parcel in) {
            return new WeaponStatusEvent(in);
        }

        @Override
        public WeaponStatusEvent[] newArray(int size) {
            return new WeaponStatusEvent[size];
        }
    };

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        dest.writeString(type);
        dest.writeString(status);
    }

    public String toString()
    {
        return ("Type: " + type + ", "
                + "Status: " + status);
    }
}
