/******************************************************************************
 * 		
 * 	 Copyright 2016, TRX Systems, Inc.  All Rights Reserved.
 * 
 *   TRX Systems, Inc.
 *   7500 Greenway Center Drive, Suite 420
 *   Greenbelt, Maryland  20770
 *   
 *   Tel:    (301) 313-0053
 *   email:  info@trxsystems.com
 * 
 *****************************************************************************/
package com.trx.neon.beta;

import android.os.RemoteException;
import android.util.Log;

import com.trx.neon.api.NeonConfig;
import com.trx.neon.binder.PublicSettingsBinder;


public class NeonConfigBeta extends NeonConfig
{
    private final static String LOG_TAG = "NeonConfigBeta";

    private boolean armyMode;
    public final static String ENABLED_CUSTOM_ACCESSORIES = "ENABLED_CUSTOM_ACCESSORIES";
    public final static String ACCESSORY_SHOVEL = "SHOVEL";
    public final static String ACCESSORY_WEAPON = "WEAPON";

    public NeonConfigBeta withArmyMode()
    {
        armyMode = true;
        return this;
    }

    @Override
    protected boolean updateSettings(PublicSettingsBinder publicSettingsBinder)
    {

        boolean set = true;
        if (armyMode)
        {
            try
            {
                set = publicSettingsBinder.setString(ENABLED_CUSTOM_ACCESSORIES, ACCESSORY_SHOVEL + "|" + ACCESSORY_WEAPON);
            }
            catch (RemoteException e)
            {
                Log.w(LOG_TAG, "Couldn't set setting: " + ENABLED_CUSTOM_ACCESSORIES, e);
                set = false;
            }
        }
        if(!set)
            return false;

        return super.updateSettings(publicSettingsBinder);
    }
}
