/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.filters.DefaultFilter;
import org.cyberneko.html.filters.Identity;
import org.cyberneko.html.filters.Writer;

public class Script
extends DefaultFilter {
    protected static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    protected static final String FILTERS = "http://cyberneko.org/html/properties/filters";
    protected static final String SCRIPT_TYPE = "text/x-nekoscript";
    protected HTMLConfiguration fConfiguration;
    protected StringBuffer fBuffer;
    protected String fSystemId;
    protected int fScriptCount;

    public Script(HTMLConfiguration hTMLConfiguration) {
        this.fConfiguration = hTMLConfiguration;
    }

    public void startDocument(XMLLocator xMLLocator, String string, Augmentations augmentations) throws XNIException {
        this.fBuffer = null;
        this.fSystemId = xMLLocator != null ? xMLLocator.getLiteralSystemId() : null;
        this.fScriptCount = 0;
        super.startDocument(xMLLocator, string, augmentations);
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        String string;
        if (qName.rawname.equalsIgnoreCase("script") && xMLAttributes != null && (string = xMLAttributes.getValue("type")) != null && string.equalsIgnoreCase(SCRIPT_TYPE)) {
            this.fBuffer = new StringBuffer();
            return;
        }
        super.startElement(qName, xMLAttributes, augmentations);
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        String string;
        if (qName.rawname.equalsIgnoreCase("script") && xMLAttributes != null && (string = xMLAttributes.getValue("type")) != null && string.equalsIgnoreCase(SCRIPT_TYPE)) {
            return;
        }
        super.emptyElement(qName, xMLAttributes, augmentations);
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fBuffer != null) {
            this.fBuffer.append(xMLString.ch, xMLString.offset, xMLString.length);
        } else {
            super.characters(xMLString, augmentations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        if (this.fBuffer != null) {
            try {
                try {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(this.fBuffer.toString()));
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    while ((string = bufferedReader.readLine()) != null) {
                        string.trim();
                        if (string.length() == 0) continue;
                        switch (string.charAt(0)) {
                            case '(': {
                                printWriter.print('<');
                                printWriter.print(string.substring(1));
                                printWriter.print('>');
                                break;
                            }
                            case '\"': {
                                printWriter.print(string.substring(1));
                                break;
                            }
                            case ')': {
                                printWriter.print("</");
                                printWriter.print(string.substring(1));
                                printWriter.print('>');
                            }
                        }
                    }
                    String string2 = this.fSystemId != null ? this.fSystemId + '_' : "";
                    ++this.fScriptCount;
                    string2 = string2 + "script" + this.fScriptCount;
                    XMLInputSource xMLInputSource = new XMLInputSource(null, string2, null, (Reader)new StringReader(stringWriter.toString()), "UTF-8");
                    this.fConfiguration.pushInputSource(xMLInputSource);
                }
                catch (IOException iOException) {
                    Object var10_11 = null;
                    this.fBuffer = null;
                }
                Object var10_10 = null;
                this.fBuffer = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.fBuffer = null;
                throw throwable;
            }
        } else {
            super.endElement(qName, augmentations);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        HTMLConfiguration hTMLConfiguration = new HTMLConfiguration();
        hTMLConfiguration.setFeature(AUGMENTATIONS, true);
        XMLDocumentFilter[] xMLDocumentFilterArray = new XMLDocumentFilter[]{new Script(hTMLConfiguration), new Identity(), new Writer()};
        hTMLConfiguration.setProperty(FILTERS, (Object)xMLDocumentFilterArray);
        int n = 0;
        while (n < stringArray.length) {
            hTMLConfiguration.parse(new XMLInputSource(null, stringArray[n], null));
            ++n;
        }
    }
}

