/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.swing;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class ContextComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private String[] values;
    private List filteredValues = new ArrayList();
    private String regexp = null;
    private Object selected;

    public int getSize() {
        return this.filteredValues.size();
    }

    public Object getElementAt(int index) {
        return this.filteredValues.get(index);
    }

    public Object getSelectedItem() {
        return this.selected;
    }

    public void setSelectedItem(Object anItem) {
        this.selected = anItem;
    }

    public void setValues(String[] values) {
        this.values = values;
        this.computeSelectedValues();
    }

    public void setFilter(String pseudoRegex) {
        if (!"".equals(pseudoRegex)) {
            if ((pseudoRegex = pseudoRegex.toLowerCase()).startsWith("*")) {
                pseudoRegex = "." + pseudoRegex;
            }
            this.regexp = ".*" + pseudoRegex + ".*";
        } else {
            this.regexp = null;
        }
        this.computeSelectedValues();
    }

    private void computeSelectedValues() {
        this.filteredValues.clear();
        if (this.regexp != null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (!Pattern.matches(this.regexp, this.values[i].toLowerCase())) continue;
                this.filteredValues.add(this.values[i]);
            }
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }
}

