/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import org.nanocontainer.guimodel.BeanProperty;
import org.nanocontainer.guimodel.ComponentAdapterModel;
import org.nanocontainer.swing.BeanPropertyEditDialog;
import org.nanocontainer.swing.ComponentAdapterTableModel;
import org.nanocontainer.swing.ContainerTree;
import org.picocontainer.ComponentAdapter;

public class ContainerTreePanel
extends JPanel {
    private final ContainerTree tree;
    private JTable table;

    public ContainerTreePanel(final ContainerTree tree, JComponent toolbar) {
        super(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(0);
        this.tree = tree;
        this.table = new JTable();
        JScrollPane topPane = new JScrollPane(this.tree);
        topPane.setMinimumSize(new Dimension(300, 150));
        topPane.setPreferredSize(new Dimension(400, 200));
        JScrollPane bottomPane = new JScrollPane(this.table);
        bottomPane.setMinimumSize(new Dimension(300, 150));
        bottomPane.setPreferredSize(new Dimension(400, 200));
        splitPane.setTopComponent(topPane);
        splitPane.setBottomComponent(bottomPane);
        this.add((Component)toolbar, "North");
        this.add((Component)splitPane, "Center");
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                TreePath selPath = evt.getNewLeadSelectionPath();
                SwingUtilities.invokeLater(new Runnable(this, selPath){
                    private final /* synthetic */ TreePath val$selPath;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$selPath = val$selPath;
                    }

                    public void run() {
                        try {
                            ComponentAdapter componentAdapter = (ComponentAdapter)this.val$selPath.getLastPathComponent();
                            TableModel model = ComponentAdapterTableModel.getInstance(componentAdapter);
                            ContainerTreePanel.access$100(1.access$000(this.this$1)).setModel(model);
                            1.access$000(this.this$1).validate();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }

            static /* synthetic */ ContainerTreePanel access$000(1 x0) {
                return x0.ContainerTreePanel.this;
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TreePath path = tree.getSelectionPath();
                    try {
                        ComponentAdapter obj = (ComponentAdapter)path.getLastPathComponent();
                        ComponentAdapterModel model = ComponentAdapterModel.getInstance(obj);
                        BeanProperty bp = model.getProperty(ContainerTreePanel.this.table.getSelectedRow());
                        if (bp.isWritable() && bp.getPropertyEditor() != null) {
                            BeanPropertyEditDialog dialog = new BeanPropertyEditDialog(bp);
                            dialog.show();
                            ContainerTreePanel.this.table.repaint();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

