/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.nanocontainer.swing.IconHelper;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class ContainerTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final Icon picoContainerIcon = IconHelper.getIcon("/org/nanocontainer/swing/icons/picocontainer.gif", false);
    private final Icon componentIcon;

    public ContainerTreeCellRenderer(Icon componentIcon) {
        this.componentIcon = componentIcon;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof PicoContainer) {
            label.setText("PicoContainer");
            this.setIcon(this.picoContainerIcon);
        } else if (value instanceof ComponentAdapter) {
            ComponentAdapter componentAdapter = (ComponentAdapter)value;
            TreeModel model = tree.getModel();
            if (model.isLeaf(value)) {
                label.setText(componentAdapter.getComponentImplementation().getName());
                try {
                    componentAdapter.verify();
                    label.setForeground(Color.black);
                }
                catch (UnsatisfiableDependenciesException e) {
                    label.setForeground(Color.red);
                }
            } else {
                label.setText(componentAdapter.getClass().getName());
            }
            this.setIcon(this.componentIcon);
        } else if (value instanceof Class) {
            Class clazz = (Class)value;
            label.setText(clazz.getName());
        } else {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(value.getClass());
                Image image = beanInfo.getIcon(1);
                Icon icon = image != null ? new ImageIcon(image) : this.componentIcon;
                this.setIcon(icon);
            }
            catch (IntrospectionException ie) {
                // empty catch block
            }
        }
        return label;
    }
}

