/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.nanocontainer.guimodel.BeanProperty;

public class BeanPropertyEditDialog
extends JDialog
implements ActionListener {
    private BeanProperty property;
    private JTextField valueText;
    private PropertyEditor editor;

    public BeanPropertyEditDialog(BeanProperty property) throws HeadlessException {
        super((Frame)null, "Bean Property", true);
        this.property = property;
        this.editor = this.property.getPropertyEditor();
        this.editor.setValue(this.property.getValue());
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        JLabel descriptionLabel = new JLabel();
        descriptionLabel.setText("Enter a the value for this property");
        gridbagconstraints.anchor = 23;
        gridbagconstraints.fill = 2;
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.weighty = 1.0;
        panel.add((Component)descriptionLabel, gridbagconstraints);
        JLabel nameLabel = new JLabel();
        nameLabel.setText(this.property.getName());
        gridbagconstraints.anchor = 24;
        gridbagconstraints.fill = 2;
        gridbagconstraints.gridwidth = -1;
        gridbagconstraints.weighty = 0.0;
        panel.add((Component)nameLabel, gridbagconstraints);
        this.valueText = new JTextField();
        this.valueText.setText(this.editor.getAsText());
        this.valueText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                BeanPropertyEditDialog.this.editor.setAsText(BeanPropertyEditDialog.this.valueText.getText());
            }
        });
        gridbagconstraints.anchor = 23;
        gridbagconstraints.fill = 2;
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.weighty = 1.0;
        panel.add((Component)this.valueText, gridbagconstraints);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        JButton button = new JButton("Ok");
        button.setActionCommand("OK");
        buttonPanel.add(button);
        button.addActionListener(this);
        button = new JButton("Cancel");
        buttonPanel.add(button);
        button.addActionListener(this);
        gridbagconstraints.anchor = 19;
        gridbagconstraints.fill = 0;
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.weighty = 0.0;
        panel.add((Component)buttonPanel, gridbagconstraints);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            this.property.setValue(this.editor.getValue());
        }
        ((Component)this).setVisible(false);
    }
}

