/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.swing;

import java.awt.Component;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class AutoCompleteComboBox
extends JComboBox {
    private static final Locale[] INSTALLED_LOCALES = Locale.getAvailableLocales();
    private ComboBoxModel model = null;

    public static void main(String[] args) {
        JFrame f = new JFrame("AutoCompleteComboBox");
        f.setDefaultCloseOperation(3);
        AutoCompleteComboBox box = new AutoCompleteComboBox(INSTALLED_LOCALES, false);
        f.getContentPane().add(box);
        f.pack();
        f.setLocationRelativeTo(null);
        ((Component)f).setVisible(true);
    }

    public AutoCompleteComboBox(Object[] items, boolean caseSensitive) {
        super(items);
        this.model = new ComboBoxModel(items);
        this.setModel(this.model);
        this.setEditable(true);
        this.setEditor(new AutoCompleteEditor(this, caseSensitive));
    }

    public AutoCompleteComboBox(Vector items, boolean caseSensitive) {
        super(items);
        this.model = new ComboBoxModel(items);
        this.setModel(this.model);
        this.setEditable(true);
        this.setEditor(new AutoCompleteEditor(this, caseSensitive));
    }

    public AutoCompleteComboBox(boolean caseSensitive) {
        this.setEditable(true);
        this.setEditor(new AutoCompleteEditor(this, caseSensitive));
    }

    public class AutoCompleteEditorComponent
    extends JTextField {
        JComboBox combo = null;
        boolean caseSensitive = false;

        public AutoCompleteEditorComponent(JComboBox combo, boolean caseSensitive) {
            this.combo = combo;
            this.caseSensitive = caseSensitive;
        }

        protected Document createDefaultModel() {
            return new PlainDocument(this){
                private final /* synthetic */ AutoCompleteEditorComponent this$1;
                {
                    this.this$1 = this$1;
                }

                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    if (str == null || str.length() == 0) {
                        return;
                    }
                    int size = this.this$1.combo.getItemCount();
                    String text = this.getText(0, this.getLength());
                    for (int i = 0; i < size; ++i) {
                        String item = this.this$1.combo.getItemAt(i).toString();
                        if (this.getLength() + str.length() > item.length()) continue;
                        if (!this.this$1.caseSensitive) {
                            if (!(text + str).equalsIgnoreCase(item) && !item.substring(0, this.getLength() + str.length()).equalsIgnoreCase(text + str)) continue;
                            this.this$1.combo.setSelectedIndex(i);
                            super.remove(0, this.getLength());
                            super.insertString(0, item, a);
                            return;
                        }
                        if (!this.this$1.caseSensitive || !(text + str).equals(item) && !item.substring(0, this.getLength() + str.length()).equals(text + str)) continue;
                        this.this$1.combo.setSelectedIndex(i);
                        super.remove(0, this.getLength());
                        super.insertString(0, item, a);
                        return;
                    }
                }
            };
        }
    }

    public class AutoCompleteEditor
    extends BasicComboBoxEditor {
        public AutoCompleteEditor(JComboBox combo, boolean caseSensitive) {
            this.editor = new AutoCompleteEditorComponent(combo, caseSensitive);
        }
    }

    public class ComboBoxModel
    extends DefaultComboBoxModel {
        private TreeSet values = new TreeSet();

        public ComboBoxModel(List items) {
            int c = items.size();
            for (int i = 0; i < c; ++i) {
                this.values.add(items.get(i).toString());
            }
            Iterator it = this.values.iterator();
            while (it.hasNext()) {
                super.addElement(it.next().toString());
            }
        }

        public ComboBoxModel(Object[] items) {
            this(Arrays.asList(items));
        }
    }
}

