/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.guimodel;

import java.util.Collection;
import java.util.Iterator;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.InstanceComponentAdapter;

public class ContainerModel {
    private final MutablePicoContainer pico;
    private boolean expandAdapters = false;

    public ContainerModel(MutablePicoContainer pico) {
        this.pico = pico;
    }

    public PicoContainer getRootContainer() {
        return this.pico;
    }

    public Object[] getAllChildren(Object node) {
        Object[] result = new Object[]{};
        if (node instanceof PicoContainer) {
            PicoContainer pc = (PicoContainer)node;
            result = this.getAllChildren(pc);
        }
        if (node instanceof ComponentAdapter) {
            ComponentAdapter componentAdapter = (ComponentAdapter)node;
            result = this.getAllChildren(componentAdapter);
        }
        return result;
    }

    public int getChildIndex(Object parent, Object child) {
        int index = -1;
        Object[] children = this.getAllChildren(parent);
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].equals(child)) continue;
            index = i;
            break;
        }
        return index;
    }

    public Object getChildAt(Object parent, int index) {
        return this.getAllChildren(parent)[index];
    }

    private Object[] getAllChildren(PicoContainer parent) {
        Collection componentAdapters = parent.getComponentAdapters();
        Object[] result = new Object[componentAdapters.size()];
        int i = 0;
        Iterator it = componentAdapters.iterator();
        while (it.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)it.next();
            if (componentAdapter instanceof InstanceComponentAdapter) {
                InstanceComponentAdapter instanceComponentAdapter = (InstanceComponentAdapter)componentAdapter;
                result[i++] = instanceComponentAdapter.getComponentInstance();
                continue;
            }
            result[i++] = componentAdapter;
        }
        return result;
    }

    private Object[] getAllChildren(ComponentAdapter parent) {
        if (this.expandAdapters) {
            if (parent instanceof DecoratingComponentAdapter) {
                DecoratingComponentAdapter dca = (DecoratingComponentAdapter)parent;
                return new Object[]{dca.getDelegate()};
            }
            return new Object[]{parent.getComponentImplementation()};
        }
        return new Object[0];
    }
}

