/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.guimodel;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.nanocontainer.guimodel.BeanProperty;
import org.picocontainer.ComponentAdapter;

public class ComponentAdapterModel {
    private static final Map models = new HashMap();
    private final PropertyDescriptor[] propertyDescriptors;
    private final MethodDescriptor[] methodDescriptors;
    private Map propertyMap = new HashMap();
    private BeanProperty[] properties;

    private ComponentAdapterModel(ComponentAdapter componentAdapter) {
        try {
            BeanInfo bi = Introspector.getBeanInfo(componentAdapter.getComponentImplementation());
            this.propertyDescriptors = bi.getPropertyDescriptors();
            this.methodDescriptors = bi.getMethodDescriptors();
        }
        catch (IntrospectionException ie) {
            throw new RuntimeException("Can't retrieve property descriptors");
        }
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public MethodDescriptor[] getMethodDescriptors() {
        return this.methodDescriptors;
    }

    public BeanProperty[] getProperties() {
        if (this.properties == null) {
            this.properties = new BeanProperty[this.propertyDescriptors.length];
            for (int i = 0; i < this.properties.length; ++i) {
                this.properties[i] = new BeanProperty(this.propertyMap, this.getPropertyDescriptors()[i]);
            }
        }
        return this.properties;
    }

    public BeanProperty getProperty(int index) {
        BeanProperty[] properties = this.getProperties();
        return properties[index];
    }

    public Object getPropertyValue(int index) {
        BeanProperty[] properties = this.getProperties();
        BeanProperty bp = properties[index];
        return bp.getValue();
    }

    public void setPropertyValue(int index, Object value) {
        BeanProperty[] properties = this.getProperties();
        BeanProperty bp = properties[index];
        bp.setValue(value);
    }

    public static ComponentAdapterModel getInstance(ComponentAdapter componentAdapter) {
        ComponentAdapterModel model = (ComponentAdapterModel)models.get(componentAdapter);
        if (model == null) {
            model = new ComponentAdapterModel(componentAdapter);
            models.put(componentAdapter, model);
        }
        return model;
    }
}

