/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.guimodel;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.Map;

public class BeanProperty {
    private final Map propertyMap;
    private PropertyDescriptor pd;
    private PropertyEditor editor = null;

    public BeanProperty(Map propertyMap, PropertyDescriptor pd) {
        this.propertyMap = propertyMap;
        this.pd = pd;
        try {
            if (pd.getPropertyEditorClass() != null) {
                this.editor = (PropertyEditor)pd.getPropertyEditorClass().newInstance();
            }
            if (this.editor == null) {
                this.editor = PropertyEditorManager.findEditor(pd.getPropertyType());
            }
        }
        catch (InstantiationException ie) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public PropertyEditor getPropertyEditor() {
        return this.editor;
    }

    public Object getValue() {
        return this.propertyMap.get(this.pd.getName());
    }

    public void setValue(Object value) {
        this.propertyMap.put(this.pd.getName(), value);
    }

    public String getName() {
        return this.pd.getDisplayName();
    }

    public boolean isReadable() {
        return this.pd.getReadMethod() != null;
    }

    public boolean isWritable() {
        return this.pd.getWriteMethod() != null;
    }
}

