/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.persistence.hibernate.classic;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import net.sf.hibernate.Databinder;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.metadata.CollectionMetadata;
import org.picocontainer.PicoInitializationException;

public class SessionFactoryDelegator
implements SessionFactory {
    SessionFactory delegate;

    public SessionFactoryDelegator(Configuration configuration) {
        try {
            this.delegate = configuration.buildSessionFactory();
        }
        catch (HibernateException ex) {
            throw new PicoInitializationException((Throwable)ex);
        }
    }

    public Session openSession(Connection connection) {
        return this.delegate.openSession(connection);
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        return this.delegate.openSession(interceptor);
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        return this.delegate.openSession(connection, interceptor);
    }

    public Session openSession() throws HibernateException {
        return this.delegate.openSession();
    }

    public Databinder openDatabinder() throws HibernateException {
        return this.delegate.openDatabinder();
    }

    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.delegate.getClassMetadata(persistentClass);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return this.delegate.getCollectionMetadata(roleName);
    }

    public Map getAllClassMetadata() throws HibernateException {
        return this.delegate.getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return this.delegate.getAllCollectionMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws HibernateException {
        try {
            this.delegate.close();
        }
        finally {
            this.delegate = null;
        }
    }

    public void evict(Class persistentClass) throws HibernateException {
        this.delegate.evict(persistentClass);
    }

    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.delegate.evict(persistentClass, id);
    }

    public void evictCollection(String roleName) throws HibernateException {
        this.delegate.evictCollection(roleName);
    }

    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.delegate.evictCollection(roleName, id);
    }

    public void evictQueries() throws HibernateException {
        this.delegate.evictQueries();
    }

    public void evictQueries(String cacheRegion) throws HibernateException {
        this.delegate.evictQueries(cacheRegion);
    }

    public Reference getReference() throws NamingException {
        return this.delegate.getReference();
    }
}

