/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.persistence.hibernate.classic;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Query;
import net.sf.hibernate.ReplicationMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.type.Type;

public abstract class SessionDelegator
implements Session {
    public abstract Session getSession();

    public abstract void invalidateSession() throws HibernateException;

    public void flush() throws HibernateException {
        try {
            this.getSession().flush();
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public void setFlushMode(FlushMode flushMode) {
        this.getSession().setFlushMode(flushMode);
    }

    public FlushMode getFlushMode() {
        return this.getSession().getFlushMode();
    }

    public SessionFactory getSessionFactory() {
        return this.getSession().getSessionFactory();
    }

    public Connection connection() throws HibernateException {
        try {
            return this.getSession().connection();
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Connection disconnect() throws HibernateException {
        try {
            return this.getSession().disconnect();
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public void reconnect() throws HibernateException {
        try {
            this.getSession().reconnect();
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public void reconnect(Connection connection) throws HibernateException {
        try {
            this.getSession().reconnect(connection);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Connection close() throws HibernateException {
        try {
            return this.getSession().close();
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public void cancelQuery() throws HibernateException {
        try {
            this.getSession().cancelQuery();
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public boolean isOpen() {
        return this.getSession().isOpen();
    }

    public boolean isConnected() {
        return this.getSession().isConnected();
    }

    public boolean isDirty() throws HibernateException {
        try {
            return this.getSession().isDirty();
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        try {
            return this.getSession().getIdentifier(object);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public boolean contains(Object object) {
        return this.getSession().contains(object);
    }

    public void evict(Object object) throws HibernateException {
        try {
            this.getSession().evict(object);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Object load(Class theClass, Serializable id, LockMode lockMode) throws HibernateException {
        try {
            return this.getSession().load(theClass, id, lockMode);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Object load(Class theClass, Serializable id) throws HibernateException {
        try {
            return this.getSession().load(theClass, id);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public void load(Object object, Serializable id) throws HibernateException {
        try {
            this.getSession().load(object, id);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public void replicate(Object object, ReplicationMode replicationMode) throws HibernateException {
        try {
            this.getSession().replicate(object, replicationMode);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Serializable save(Object object) throws HibernateException {
        try {
            return this.getSession().save(object);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public void save(Object object, Serializable id) throws HibernateException {
        try {
            this.getSession().save(object, id);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public void saveOrUpdate(Object object) throws HibernateException {
        try {
            this.getSession().saveOrUpdate(object);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public void update(Object object) throws HibernateException {
        try {
            this.getSession().update(object);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public void update(Object object, Serializable id) throws HibernateException {
        try {
            this.getSession().update(object, id);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Object saveOrUpdateCopy(Object object) throws HibernateException {
        try {
            return this.getSession().saveOrUpdateCopy(object);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Object saveOrUpdateCopy(Object object, Serializable id) throws HibernateException {
        try {
            return this.getSession().saveOrUpdateCopy(object, id);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public void delete(Object object) throws HibernateException {
        try {
            this.getSession().delete(object);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public List find(String query) throws HibernateException {
        try {
            return this.getSession().find(query);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public List find(String query, Object value, Type type) throws HibernateException {
        try {
            return this.getSession().find(query, value, type);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public List find(String query, Object[] values, Type[] types) throws HibernateException {
        try {
            return this.getSession().find(query, values, types);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Iterator iterate(String query) throws HibernateException {
        try {
            return this.getSession().iterate(query);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Iterator iterate(String query, Object value, Type type) throws HibernateException {
        try {
            return this.getSession().iterate(query, value, type);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Iterator iterate(String query, Object[] values, Type[] types) throws HibernateException {
        try {
            return this.getSession().iterate(query, values, types);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Collection filter(Object collection, String filter) throws HibernateException {
        try {
            return this.getSession().filter(collection, filter);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Collection filter(Object collection, String filter, Object value, Type type) throws HibernateException {
        try {
            return this.getSession().filter(collection, filter, value, type);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Collection filter(Object collection, String filter, Object[] values, Type[] types) throws HibernateException {
        try {
            return this.getSession().filter(collection, filter, values, types);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public int delete(String query) throws HibernateException {
        try {
            return this.getSession().delete(query);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public int delete(String query, Object value, Type type) throws HibernateException {
        try {
            return this.getSession().delete(query, value, type);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public int delete(String query, Object[] values, Type[] types) throws HibernateException {
        try {
            return this.getSession().delete(query, values, types);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public void lock(Object object, LockMode lockMode) throws HibernateException {
        try {
            this.getSession().lock(object, lockMode);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public void refresh(Object object) throws HibernateException {
        try {
            this.getSession().refresh(object);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        try {
            this.getSession().refresh(object, lockMode);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        try {
            return this.getSession().getCurrentLockMode(object);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Transaction beginTransaction() throws HibernateException {
        try {
            return this.getSession().beginTransaction();
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Criteria createCriteria(Class persistentClass) {
        return this.getSession().createCriteria(persistentClass);
    }

    public Query createQuery(String queryString) throws HibernateException {
        try {
            return this.getSession().createQuery(queryString);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Query createFilter(Object collection, String queryString) throws HibernateException {
        try {
            return this.getSession().createFilter(collection, queryString);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Query getNamedQuery(String queryName) throws HibernateException {
        try {
            return this.getSession().getNamedQuery(queryName);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Query createSQLQuery(String sql, String returnAlias, Class returnClass) {
        return this.getSession().createSQLQuery(sql, returnAlias, returnClass);
    }

    public Query createSQLQuery(String sql, String[] returnAliases, Class[] returnClasses) {
        return this.getSession().createSQLQuery(sql, returnAliases, returnClasses);
    }

    public void clear() {
        this.getSession().clear();
    }

    public Object get(Class clazz, Serializable id) throws HibernateException {
        try {
            return this.getSession().get(clazz, id);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }

    public Object get(Class clazz, Serializable id, LockMode lockMode) throws HibernateException {
        try {
            return this.getSession().get(clazz, id, lockMode);
        }
        catch (HibernateException ex) {
            this.invalidateSession();
            throw ex;
        }
    }
}

