/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.persistence.hibernate.classic;

import java.sql.Connection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.nanocontainer.persistence.hibernate.classic.SessionDelegator;
import org.picocontainer.PicoInitializationException;

public class FailoverSessionDelegator
extends SessionDelegator {
    SessionFactory sessionFactory;
    Session session = null;

    public FailoverSessionDelegator(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Session getSession() {
        if (this.session == null) {
            try {
                this.session = this.sessionFactory.openSession();
            }
            catch (HibernateException ex) {
                throw new PicoInitializationException((Throwable)ex);
            }
        }
        return this.session;
    }

    public Connection close() throws HibernateException {
        Connection retval = null;
        try {
            retval = this.getSession().close();
        }
        catch (HibernateException ex) {
            throw ex;
        }
        finally {
            this.session = null;
        }
        return retval;
    }

    public void invalidateSession() throws HibernateException {
        if (this.session != null) {
            try {
                this.session.clear();
                this.session.close();
            }
            catch (HibernateException ex) {
                throw ex;
            }
            finally {
                this.session = null;
            }
        }
    }
}

