/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.persistence.hibernate;

import java.sql.Connection;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.nanocontainer.persistence.hibernate.SessionDelegator;

public class FailoverSessionDelegator
extends SessionDelegator {
    private SessionFactory sessionFactory;
    private Session session = null;

    public FailoverSessionDelegator(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Session getDelegatedSession() {
        if (this.session == null) {
            try {
                this.session = this.sessionFactory.openSession();
            }
            catch (HibernateException ex) {
                throw this.handleException(ex);
            }
        }
        return this.session;
    }

    public Connection close() throws HibernateException {
        try {
            Connection connection = this.getDelegatedSession().close();
            return connection;
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        finally {
            this.session = null;
        }
    }

    public void invalidateDelegatedSession() throws HibernateException {
        if (this.session != null) {
            try {
                this.session.clear();
                this.session.close();
            }
            catch (HibernateException ex) {
                throw this.handleException(ex);
            }
            finally {
                this.session = null;
            }
        }
    }
}

