/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.nanowar.webwork;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.nanocontainer.nanowar.KeyConstants;
import org.nanocontainer.nanowar.RequestScopeObjectReference;
import org.nanocontainer.nanowar.webwork.ActionContextScopeObjectReference;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import webwork.action.Action;
import webwork.action.ServletActionContext;
import webwork.action.factory.ActionFactory;

public class PicoActionFactory
extends ActionFactory
implements KeyConstants {
    private Map classCache = new HashMap();

    public Action getActionImpl(String className) throws Exception {
        Class actionClass = this.loadClass(className);
        if (actionClass == null) {
            return null;
        }
        Action action = null;
        try {
            action = this.instantiateAction(actionClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return action;
    }

    protected Class loadClass(String className) {
        if (this.classCache.containsKey(className)) {
            return (Class)this.classCache.get(className);
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> result = classLoader.loadClass(className);
            this.classCache.put(className, result);
            return result;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected Action instantiateAction(Class actionClass) {
        PicoContainer requestContainer = this.getParentContainer();
        Action result = (Action)requestContainer.getComponentInstance((Object)actionClass);
        if (result == null) {
            DefaultPicoContainer tempContainer = new DefaultPicoContainer(requestContainer);
            tempContainer.registerComponentImplementation(actionClass);
            result = (Action)tempContainer.getComponentInstance((Object)actionClass);
        }
        return result;
    }

    private PicoContainer getParentContainer() {
        HttpServletRequest request = ServletActionContext.getRequest();
        Object ref = request != null ? new RequestScopeObjectReference((ServletRequest)request, "nanocontainer.request") : new ActionContextScopeObjectReference("nanocontainer.request");
        return (PicoContainer)ref.get();
    }
}

