/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.nanowar.nanoweb;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ognl.Ognl;
import ognl.OgnlException;
import org.nanocontainer.nanowar.ApplicationScopeObjectReference;
import org.nanocontainer.nanowar.KeyConstants;
import org.nanocontainer.nanowar.RequestScopeObjectReference;
import org.nanocontainer.nanowar.ServletRequestContainerLauncher;
import org.nanocontainer.nanowar.nanoweb.CachingScriptClassLoader;
import org.nanocontainer.nanowar.nanoweb.ChainingDispatcher;
import org.nanocontainer.nanowar.nanoweb.Dispatcher;
import org.nanocontainer.nanowar.nanoweb.ScriptException;
import org.picocontainer.MutablePicoContainer;

public class NanoWebServlet
extends HttpServlet
implements KeyConstants {
    private Dispatcher dispatcher;
    private final CachingScriptClassLoader cachingScriptClassLoader = new CachingScriptClassLoader();
    static /* synthetic */ Class class$org$nanocontainer$nanowar$nanoweb$Dispatcher;

    public void init() throws ServletException {
        ServletContext servletContext = this.getServletContext();
        MutablePicoContainer applicationContainer = this.getApplicationContainer(servletContext);
        this.initDispatcher(applicationContainer);
    }

    private void initDispatcher(MutablePicoContainer applicationContainer) {
        this.dispatcher = (Dispatcher)applicationContainer.getComponentInstanceOfType(class$org$nanocontainer$nanowar$nanoweb$Dispatcher == null ? (class$org$nanocontainer$nanowar$nanoweb$Dispatcher = NanoWebServlet.class$("org.nanocontainer.nanowar.nanoweb.Dispatcher")) : class$org$nanocontainer$nanowar$nanoweb$Dispatcher);
        if (this.dispatcher == null) {
            this.dispatcher = new ChainingDispatcher(".vm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletRequestContainerLauncher containerLauncher = new ServletRequestContainerLauncher(this.getServletContext(), httpServletRequest);
        try {
            containerLauncher.startContainer();
            String servletPath = NanoWebServlet.getServletPath(httpServletRequest);
            String scriptPathWithoutExtension = servletPath.substring(0, servletPath.lastIndexOf(47));
            Object action = this.getActionObject(scriptPathWithoutExtension, httpServletRequest);
            this.setPropertiesWithOgnl(httpServletRequest, action);
            int dot = servletPath.lastIndexOf(46);
            String actionMethod = servletPath.substring(servletPath.lastIndexOf(47) + 1, dot);
            String result = this.execute(action, actionMethod);
            httpServletRequest.setAttribute("action", action);
            ServletContext servletContext = this.getServletContext();
            this.dispatcher.dispatch(servletContext, httpServletRequest, httpServletResponse, scriptPathWithoutExtension, actionMethod, result);
        }
        catch (ScriptException e) {
            this.handleServiceScriptException(e, httpServletResponse, httpServletRequest);
        }
        finally {
            containerLauncher.killContainer();
        }
    }

    protected void handleServiceScriptException(ScriptException e, HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) throws IOException {
        int c;
        e.printStackTrace();
        PrintWriter writer = httpServletResponse.getWriter();
        writer.println("<html>");
        writer.println("<pre>");
        e.printStackTrace(writer);
        writer.println(httpServletRequest.getRequestURI());
        URL scriptURL = e.getScriptURL();
        InputStream in = scriptURL.openStream();
        while ((c = in.read()) != -1) {
            writer.write(c);
        }
        writer.println("</pre>");
        writer.println("</html>");
    }

    private Object getActionObject(String path, HttpServletRequest request) throws ServletException, ScriptException {
        MutablePicoContainer requestContainer = this.getRequestContainer((ServletRequest)request);
        Object action = requestContainer.getComponentInstance((Object)path);
        if (action == null) {
            try {
                action = this.getScriptAction(path + ".groovy", requestContainer);
            }
            catch (IOException e) {
                this.log("Failed to load action class", e);
                throw new ServletException((Throwable)e);
            }
        }
        if (action == null) {
            String msg = "No action found for '" + path + "'";
            throw new ServletException(msg);
        }
        return action;
    }

    private Object getScriptAction(String scriptPath, MutablePicoContainer requestContainer) throws IOException, ScriptException {
        URL scriptURL = this.getServletContext().getResource(scriptPath);
        Object result = null;
        if (scriptURL != null) {
            Class scriptClass = this.cachingScriptClassLoader.getClass(scriptURL);
            requestContainer.registerComponentImplementation((Object)scriptPath, scriptClass);
            result = requestContainer.getComponentInstance((Object)scriptPath);
        }
        return result;
    }

    private void setPropertiesWithOgnl(HttpServletRequest servletRequest, Object action) throws ServletException {
        Enumeration parameterNames = servletRequest.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterValue = servletRequest.getParameter(parameterName);
            try {
                Ognl.setValue((String)parameterName, (Object)action, (Object)parameterValue);
            }
            catch (OgnlException e) {
                this.log("Failed to set property with OGNL", e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    private String execute(Object actionObject, String actionMethodName) throws ServletException {
        Method actionMethod = null;
        try {
            actionMethod = actionObject.getClass().getMethod(actionMethodName, null);
        }
        catch (NoSuchMethodException e) {
            String message = "The " + actionObject.getClass().getName() + " doesn't have the method " + actionMethodName + "()";
            this.log(message, e);
            throw new ServletException(message, (Throwable)e);
        }
        try {
            String view = (String)actionMethod.invoke(actionObject, null);
            return view;
        }
        catch (IllegalAccessException e) {
            String message = actionObject.getClass().getName() + "." + actionMethodName + "() isn't public";
            this.log(message, e);
            throw new ServletException(message, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String message = "Failed to actionMethod " + actionObject.getClass().getName() + "." + actionMethodName + "()";
            this.log(message, e);
            throw new ServletException(message, (Throwable)e);
        }
    }

    static String getServletPath(HttpServletRequest httpServletRequest) {
        String servletPath = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = httpServletRequest.getServletPath();
        }
        return servletPath;
    }

    private MutablePicoContainer getApplicationContainer(ServletContext context) {
        ApplicationScopeObjectReference ref = new ApplicationScopeObjectReference(context, "nanocontainer.application");
        return (MutablePicoContainer)ref.get();
    }

    private MutablePicoContainer getRequestContainer(ServletRequest request) {
        RequestScopeObjectReference ref = new RequestScopeObjectReference(request, "nanocontainer.request");
        return (MutablePicoContainer)ref.get();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

