/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.nanowar.nanoweb;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nanocontainer.nanowar.nanoweb.Dispatcher;

public class ChainingDispatcher
implements Dispatcher {
    private final String extension;

    public ChainingDispatcher(String extension) {
        this.extension = extension;
    }

    public void dispatch(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String scriptPathWithoutExtension, String actionMethod, String result) throws IOException, ServletException {
        String[] views = this.getViews(scriptPathWithoutExtension, actionMethod, result);
        boolean didDispatch = false;
        for (int i = 0; i < views.length; ++i) {
            String view = views[i];
            URL viewURL = servletContext.getResource(view);
            if (viewURL == null) continue;
            RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(view);
            if (httpServletRequest.getAttribute("javax.servlet.include.servlet_path") == null) {
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            didDispatch = true;
            break;
        }
        if (!didDispatch) {
            throw new ServletException("Couldn't dispatch to any of " + Arrays.asList(views).toString());
        }
    }

    String[] getViews(String scriptPathWithoutExtension, String actionMethod, String result) {
        String[] views = new String[]{this.getScriptPathUnderscoreActionNameUnderscoreResultView(scriptPathWithoutExtension, actionMethod, result), this.getScriptPathUnderscoreResultView(scriptPathWithoutExtension, result), this.getActionFolderPathResultView(scriptPathWithoutExtension, result), this.getActionRootResultView(result)};
        return views;
    }

    private String getScriptPathUnderscoreResultView(String scriptPathWithoutExtension, String result) {
        return scriptPathWithoutExtension + "_" + result + this.extension;
    }

    private String getScriptPathUnderscoreActionNameUnderscoreResultView(String scriptPathWithoutExtension, String actionMethod, String result) {
        return scriptPathWithoutExtension + "_" + actionMethod + "_" + result + this.extension;
    }

    private String getActionFolderPathResultView(String scriptPathWithoutExtension, String result) {
        String actionFolderPath = scriptPathWithoutExtension.substring(0, scriptPathWithoutExtension.lastIndexOf("/") + 1);
        String view = actionFolderPath + result + this.extension;
        return view;
    }

    private String getActionRootResultView(String result) {
        return "/" + result + this.extension;
    }
}

