/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.nanowar;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.nanocontainer.DefaultNanoContainer;
import org.nanocontainer.integrationkit.ContainerBuilder;
import org.nanocontainer.integrationkit.ContainerComposer;
import org.nanocontainer.integrationkit.DefaultLifecycleContainerBuilder;
import org.nanocontainer.integrationkit.PicoCompositionException;
import org.nanocontainer.nanowar.ApplicationScopeObjectReference;
import org.nanocontainer.nanowar.KeyConstants;
import org.nanocontainer.nanowar.SessionScopeObjectReference;
import org.nanocontainer.script.ScriptedContainerBuilder;
import org.nanocontainer.script.ScriptedContainerBuilderFactory;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ConstantParameter;
import org.picocontainer.defaults.ObjectReference;
import org.picocontainer.defaults.SimpleReference;

public class ServletContainerListener
implements ServletContextListener,
HttpSessionListener,
KeyConstants,
Serializable {
    private transient ContainerBuilder containerKiller = new DefaultLifecycleContainerBuilder(null);
    public static final String KILLER_HELPER = "KILLER_HELPER";
    public static final String NANOCONTAINER_PREFIX = "nanocontainer";
    public static final String CONTAINER_COMPOSER = ContainerComposer.class.getName();
    public static final String CONTAINER_COMPOSER_CONFIGURATION = CONTAINER_COMPOSER + ".configuration";

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        try {
            ContainerBuilder containerBuilder = this.createBuilder(context);
            ApplicationScopeObjectReference builderRef = new ApplicationScopeObjectReference(context, "nanocontainer.builder");
            builderRef.set(containerBuilder);
            ApplicationScopeObjectReference containerRef = new ApplicationScopeObjectReference(context, "nanocontainer.application");
            containerBuilder.buildContainer((ObjectReference)containerRef, (ObjectReference)new SimpleReference(), (Object)context, false);
        }
        catch (ClassNotFoundException e) {
            event.getServletContext().log(e.getMessage(), (Throwable)e);
            throw new PicoCompositionException((Throwable)e);
        }
    }

    private ContainerBuilder createBuilder(ServletContext context) throws ClassNotFoundException {
        Enumeration initParameters = context.getInitParameterNames();
        while (initParameters.hasMoreElements()) {
            String initParameter = (String)initParameters.nextElement();
            if (initParameter.startsWith(NANOCONTAINER_PREFIX)) {
                String builderClassName = this.getBuilderClassName(initParameter);
                String script = context.getInitParameter(initParameter);
                Reader scriptReader = script.trim().startsWith("/") && !script.trim().startsWith("//") && !script.trim().startsWith("/*") ? new InputStreamReader(context.getResourceAsStream(script)) : new StringReader(script);
                ScriptedContainerBuilderFactory scriptedContainerBuilderFactory = new ScriptedContainerBuilderFactory(scriptReader, builderClassName, Thread.currentThread().getContextClassLoader());
                return scriptedContainerBuilderFactory.getContainerBuilder();
            }
            if (!initParameter.equals(CONTAINER_COMPOSER)) continue;
            ContainerComposer containerComposer = this.createContainerComposer(context);
            return new DefaultLifecycleContainerBuilder(containerComposer);
        }
        throw new PicoCompositionException("Couldn't create a builder from context parameters in web.xml");
    }

    private ContainerComposer createContainerComposer(ServletContext context) throws ClassNotFoundException {
        String containerComposerClassName = context.getInitParameter(CONTAINER_COMPOSER);
        DefaultNanoContainer nanoContainer = new DefaultNanoContainer(Thread.currentThread().getContextClassLoader());
        String script = context.getInitParameter(CONTAINER_COMPOSER_CONFIGURATION);
        PicoContainer picoConfiguration = null;
        if (script != null) {
            InputStreamReader scriptReader = new InputStreamReader(context.getResourceAsStream(script));
            String builderClassName = this.getBuilderClassName(script);
            ScriptedContainerBuilderFactory scriptedContainerBuilderFactory = new ScriptedContainerBuilderFactory((Reader)scriptReader, builderClassName, Thread.currentThread().getContextClassLoader());
            picoConfiguration = this.buildContainer(scriptedContainerBuilderFactory.getContainerBuilder());
        }
        ComponentAdapter componentAdapter = null;
        if (picoConfiguration != null) {
            Parameter[] parameters = new Parameter[]{new ConstantParameter(picoConfiguration)};
            componentAdapter = nanoContainer.registerComponentImplementation((Object)containerComposerClassName, containerComposerClassName, parameters);
        } else {
            componentAdapter = nanoContainer.registerComponentImplementation(containerComposerClassName);
        }
        return (ContainerComposer)componentAdapter.getComponentInstance((PicoContainer)nanoContainer.getPico());
    }

    private String getBuilderClassName(String scriptName) {
        String extension = scriptName.substring(scriptName.lastIndexOf(46));
        return ScriptedContainerBuilderFactory.getBuilderClassName((String)extension);
    }

    protected PicoContainer buildContainer(ScriptedContainerBuilder builder) {
        SimpleReference containerRef = new SimpleReference();
        builder.buildContainer((ObjectReference)containerRef, (ObjectReference)new SimpleReference(), (Object)new SimpleReference(), false);
        return (PicoContainer)containerRef.get();
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        ApplicationScopeObjectReference containerRef = new ApplicationScopeObjectReference(context, "nanocontainer.application");
        this.killContainer(containerRef);
    }

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        ServletContext context = session.getServletContext();
        ContainerBuilder containerBuilder = this.getBuilder(context);
        SessionScopeObjectReference sessionContainerRef = new SessionScopeObjectReference(session, "nanocontainer.session");
        ApplicationScopeObjectReference webappContainerRef = new ApplicationScopeObjectReference(context, "nanocontainer.application");
        containerBuilder.buildContainer((ObjectReference)sessionContainerRef, (ObjectReference)webappContainerRef, (Object)session, false);
        session.setAttribute(KILLER_HELPER, (Object)new ContainerKillerHelper(){

            public void valueBound(HttpSessionBindingEvent bindingEvent) {
                HttpSession session = bindingEvent.getSession();
                this.containerRef = new SimpleReference();
                this.containerRef.set(new SessionScopeObjectReference(session, "nanocontainer.session").get());
            }

            public void valueUnbound(HttpSessionBindingEvent event) {
                try {
                    ServletContainerListener.this.killContainer((ObjectReference)this.containerRef);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        });
    }

    public void sessionDestroyed(HttpSessionEvent event) {
    }

    private ContainerBuilder getBuilder(ServletContext context) {
        ApplicationScopeObjectReference assemblerRef = new ApplicationScopeObjectReference(context, "nanocontainer.builder");
        return (ContainerBuilder)assemblerRef.get();
    }

    private void killContainer(ObjectReference containerRef) {
        if (containerRef.get() != null) {
            this.containerKiller.killContainer(containerRef);
        }
    }

    private abstract class ContainerKillerHelper
    implements HttpSessionBindingListener,
    Serializable {
        SimpleReference containerRef;

        private ContainerKillerHelper() {
        }
    }
}

