/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.nanowar;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.nanocontainer.DefaultNanoContainer;
import org.nanocontainer.integrationkit.ContainerComposer;
import org.nanocontainer.integrationkit.ContainerPopulator;
import org.nanocontainer.integrationkit.ContainerRecorder;
import org.nanocontainer.nanowar.ScopedContainerConfigurator;
import org.nanocontainer.reflection.DefaultContainerRecorder;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ConstantParameter;
import org.picocontainer.defaults.DefaultPicoContainer;

public class ScopedContainerComposer
implements ContainerComposer {
    private String containerBuilderClassName;
    private ContainerRecorder applicationRecorder;
    private ContainerRecorder requestRecorder;
    private ContainerRecorder sessionRecorder;

    public ScopedContainerComposer() throws ClassNotFoundException {
        this((PicoContainer)new DefaultPicoContainer());
    }

    public ScopedContainerComposer(PicoContainer configuration) throws ClassNotFoundException {
        ScopedContainerConfigurator config = this.getConfigurator(configuration);
        this.containerBuilderClassName = config.getContainerBuilder();
        this.applicationRecorder = new DefaultContainerRecorder((MutablePicoContainer)new DefaultPicoContainer());
        this.populateContainer(config.getApplicationConfig(), this.applicationRecorder);
        this.sessionRecorder = new DefaultContainerRecorder(this.applicationRecorder.getContainerProxy());
        this.populateContainer(config.getSessionConfig(), this.sessionRecorder);
        this.requestRecorder = new DefaultContainerRecorder(this.sessionRecorder.getContainerProxy());
        this.populateContainer(config.getRequestConfig(), this.requestRecorder);
    }

    public void composeContainer(MutablePicoContainer container, Object scope) {
        if (scope instanceof ServletContext) {
            this.applicationRecorder.replay(container);
        } else if (scope instanceof HttpSession) {
            this.sessionRecorder.replay(container);
        } else if (scope instanceof HttpServletRequest) {
            this.requestRecorder.replay(container);
        }
    }

    private ScopedContainerConfigurator getConfigurator(PicoContainer pico) {
        ScopedContainerConfigurator configurator = (ScopedContainerConfigurator)pico.getComponentInstance((Object)ScopedContainerConfigurator.class);
        if (configurator == null) {
            configurator = new ScopedContainerConfigurator();
        }
        return configurator;
    }

    private void populateContainer(String resources, ContainerRecorder recorder) throws ClassNotFoundException {
        MutablePicoContainer container = recorder.getContainerProxy();
        String[] resourcePaths = this.toCSV(resources);
        for (int i = 0; i < resourcePaths.length; ++i) {
            ContainerPopulator populator = this.createContainerPopulator(this.getResource(resourcePaths[i]));
            populator.populateContainer(container);
        }
    }

    private String[] toCSV(String resources) {
        StringTokenizer st = new StringTokenizer(resources, ",");
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken().trim());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private ContainerPopulator createContainerPopulator(Reader reader) throws ClassNotFoundException {
        DefaultNanoContainer nano = new DefaultNanoContainer(this.getClassLoader());
        Parameter[] parameters = new Parameter[]{new ConstantParameter((Object)reader), new ConstantParameter((Object)this.getClassLoader())};
        nano.registerComponentImplementation((Object)this.containerBuilderClassName, this.containerBuilderClassName, parameters);
        return (ContainerPopulator)nano.getPico().getComponentInstance((Object)this.containerBuilderClassName);
    }

    private Reader getResource(String resource) {
        return new InputStreamReader(this.getClassLoader().getResourceAsStream(resource));
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

