/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.nanning;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.nanning.AspectInstance;
import org.codehaus.nanning.Mixin;
import org.codehaus.nanning.config.Aspect;
import org.codehaus.nanning.config.AspectSystem;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.DecoratingComponentAdapterFactory;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public class NanningComponentAdapterFactory
extends DecoratingComponentAdapterFactory
implements Serializable {
    private AspectSystem aspectSystem;

    public NanningComponentAdapterFactory(AspectSystem aspectSystem, ComponentAdapterFactory delegate) {
        super(delegate);
        this.aspectSystem = aspectSystem;
    }

    public NanningComponentAdapterFactory() {
        this(new AspectSystem(), (ComponentAdapterFactory)new DefaultComponentAdapterFactory());
    }

    public ComponentAdapter createComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object componentAdapter = super.createComponentAdapter(componentKey, componentImplementation, parameters);
        if (Aspect.class.isAssignableFrom(componentImplementation)) {
            componentAdapter = new AspectAdapter((ComponentAdapter)componentAdapter, this.aspectSystem);
        } else if (this.canBeWeaved(componentImplementation)) {
            Class componentInterface = this.getComponentInterface(componentImplementation);
            componentAdapter = new WeavingAdapter((ComponentAdapter)componentAdapter, this.aspectSystem, componentInterface);
        }
        return componentAdapter;
    }

    private Class getComponentInterface(Class componentImplementation) {
        return (Class)this.getAllInterfaces(componentImplementation).get(0);
    }

    List getAllInterfaces(Class componentImplementation) {
        if (componentImplementation == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList(Arrays.asList(componentImplementation.getInterfaces()));
        result.addAll(this.getAllInterfaces(componentImplementation.getSuperclass()));
        return result;
    }

    private boolean canBeWeaved(Class componentImplementation) {
        return this.getAllInterfaces(componentImplementation).size() == 1;
    }

    public static class AspectAdapter
    extends DecoratingComponentAdapter {
        private AspectSystem aspectSystem;

        public AspectAdapter(ComponentAdapter delegate, AspectSystem aspectSystem) {
            super(delegate);
            this.aspectSystem = aspectSystem;
        }

        public Object getComponentInstance(PicoContainer pico) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
            Aspect aspect = (Aspect)super.getComponentInstance(pico);
            this.getAspectSystem().addAspect(aspect);
            return aspect;
        }

        private AspectSystem getAspectSystem() {
            return this.aspectSystem;
        }
    }

    public static class WeavingAdapter
    extends DecoratingComponentAdapter {
        private final AspectSystem aspectSystem;
        private Class componentInterface;

        public WeavingAdapter(ComponentAdapter delegate, AspectSystem aspectSystem, Class componentInterface) {
            super(delegate);
            this.aspectSystem = aspectSystem;
            this.componentInterface = componentInterface;
        }

        public Object getComponentInstance(PicoContainer pico) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
            Object component = super.getComponentInstance(pico);
            AspectInstance aspectInstance = new AspectInstance(this.componentInterface);
            Mixin mixin = new Mixin(this.componentInterface, component);
            aspectInstance.addMixin(mixin);
            this.getAspectSystem().initialize(aspectInstance);
            component = aspectInstance.getProxy();
            return component;
        }

        private AspectSystem getAspectSystem() {
            return this.aspectSystem;
        }
    }
}

