/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.jmx;

import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.nanocontainer.jmx.MX4JInitializationException;
import org.nanocontainer.jmx.PicoContainerMBean;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public class MX4JComponentAdapter
extends DecoratingComponentAdapter {
    private final MBeanServer mbeanServer;

    public MX4JComponentAdapter(MBeanServer mbeanServer, ComponentAdapter delegate) {
        super(delegate);
        this.mbeanServer = mbeanServer;
    }

    public Object getComponentInstance() throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object componentInstance = super.getComponentInstance();
        ObjectName name = null;
        try {
            name = MX4JComponentAdapter.asObjectName(this.getComponentKey());
            PicoContainerMBean mbean = new PicoContainerMBean(componentInstance);
            this.mbeanServer.registerMBean((Object)mbean, name);
        }
        catch (MalformedObjectNameException e) {
            throw new MX4JInitializationException("Failed to register MBean '" + name + "' for component '" + this.getComponentKey() + "', due to " + e.getMessage(), e);
        }
        catch (MBeanRegistrationException e) {
            throw new MX4JInitializationException("Failed to register MBean '" + name + "' for component '" + this.getComponentKey() + "', due to " + e.getMessage(), e);
        }
        catch (NotCompliantMBeanException e) {
            throw new MX4JInitializationException("Failed to register MBean '" + name + "' for component '" + this.getComponentKey() + "', due to " + e.getMessage(), e);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new MX4JInitializationException("Failed to register MBean '" + name + "' for component '" + this.getComponentKey() + "', due to " + e.getMessage(), e);
        }
        return componentInstance;
    }

    private static ObjectName asObjectName(Object componentKey) throws MalformedObjectNameException {
        if (componentKey == null) {
            throw new NullPointerException("componentKey cannot be null");
        }
        if (componentKey instanceof ObjectName) {
            return (ObjectName)componentKey;
        }
        if (componentKey instanceof Class) {
            Class clazz = (Class)componentKey;
            return new ObjectName("picomx:type=" + clazz.getName());
        }
        String text = componentKey.toString();
        if (text.indexOf(58) == -1) {
            text = "picomx:type=" + text;
        }
        return new ObjectName(text);
    }
}

