/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.nanning.profiler;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.codehaus.nanning.Invocation;
import org.codehaus.nanning.MethodInterceptor;
import org.codehaus.nanning.profiler.ProfilerLogger;

public class ProfilerInterceptor
implements MethodInterceptor {
    static ThreadLocal threadLocal = new ThreadLocal();
    private static long minDuration = 0L;

    public Object invoke(Invocation invocation) throws Throwable {
        HashMap<Method, Long> methodsStartingTime = (HashMap<Method, Long>)threadLocal.get();
        if (methodsStartingTime == null) {
            methodsStartingTime = new HashMap<Method, Long>();
            threadLocal.set(methodsStartingTime);
        }
        Method method = invocation.getMethod();
        methodsStartingTime.put(method, new Long(System.currentTimeMillis()));
        Object result = invocation.invokeNext();
        long duration = System.currentTimeMillis() - (Long)methodsStartingTime.get(method);
        if (duration >= minDuration) {
            ProfilerLogger.getProfilerLogger().log(invocation, duration);
        }
        return result;
    }

    public static long getMinDuration() {
        return minDuration;
    }

    public static void setMinDuration(long l) {
        minDuration = l;
    }
}

