/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.nanning.prevayler;

import java.lang.reflect.Method;
import org.codehaus.nanning.Invocation;
import org.codehaus.nanning.MethodInterceptor;
import org.codehaus.nanning.attribute.Attributes;
import org.codehaus.nanning.prevayler.CurrentPrevayler;
import org.codehaus.nanning.prevayler.InvokeCommand;
import org.codehaus.nanning.prevayler.PrevaylerUtils;

public class PrevaylerInterceptor
implements MethodInterceptor {
    private boolean resolveEntities;

    public PrevaylerInterceptor(boolean resolveEntities) {
        this.resolveEntities = resolveEntities;
    }

    public boolean interceptsConstructor(Class interfaceClass) {
        return Attributes.hasAttribute((Class)interfaceClass, (String)"entity");
    }

    public boolean interceptsMethod(Method method) {
        return Attributes.hasAttribute((Method)method, (String)"transaction");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        if (CurrentPrevayler.hasPrevayler() && !CurrentPrevayler.isInTransaction() && (PrevaylerUtils.isService(invocation.getTargetInterface()) || PrevaylerUtils.isEntity(invocation.getTargetInterface()))) {
            Object object;
            CurrentPrevayler.enterTransaction();
            try {
                InvokeCommand command = new InvokeCommand(invocation, this.resolveEntities);
                object = command.executeUsing(CurrentPrevayler.getPrevayler());
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                CurrentPrevayler.exitTransaction();
                throw throwable;
            }
            CurrentPrevayler.exitTransaction();
            return object;
        }
        return invocation.invokeNext();
    }

    static boolean transactionalReturnValue(Method method) {
        return PrevaylerInterceptor.isTransactional(method.getReturnType());
    }

    public static boolean isTransactional(Class aClass) {
        if (aClass == null) {
            return false;
        }
        Method[] methods = aClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (Attributes.hasAttribute((Method)method, (String)"transaction")) {
                return true;
            }
            ++i;
        }
        Class<?>[] interfaces = aClass.getInterfaces();
        int i2 = 0;
        while (i2 < interfaces.length) {
            Class<?> anInterface = interfaces[i2];
            if (PrevaylerInterceptor.isTransactional(anInterface)) {
                return true;
            }
            ++i2;
        }
        return PrevaylerInterceptor.isTransactional(aClass.getSuperclass());
    }
}

