/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.nanning.prevayler;

import org.codehaus.nanning.AspectInstance;
import org.codehaus.nanning.ConstructionInterceptor;
import org.codehaus.nanning.MethodInterceptor;
import org.codehaus.nanning.config.Aspect;
import org.codehaus.nanning.config.P;
import org.codehaus.nanning.config.Pointcut;
import org.codehaus.nanning.prevayler.CheckTransactionUnsupportedInterceptor;
import org.codehaus.nanning.prevayler.PrevaylerInterceptor;
import org.codehaus.nanning.prevayler.PrevaylerUtils;
import org.codehaus.nanning.prevayler.RegisterObjectInterceptor;
import org.codehaus.nanning.prevayler.TransactionUnsupportedInterceptor;

public class PrevaylerAspect
implements Aspect {
    private TransactionUnsupportedInterceptor unsupportedInterceptor;
    private CheckTransactionUnsupportedInterceptor checkUnsupportedInterceptor;
    private PrevaylerInterceptor prevaylerInterceptor;
    private RegisterObjectInterceptor registerObjectInterceptor;
    private Pointcut transactionUnsupportedPointcut = P.methodAttribute((String)"transaction-unsupported");
    private Pointcut transactionPointcut = P.methodAttribute((String)"transaction");

    public PrevaylerAspect() {
        this(false);
    }

    public PrevaylerAspect(boolean useIdentification) {
        this.unsupportedInterceptor = new TransactionUnsupportedInterceptor();
        this.checkUnsupportedInterceptor = new CheckTransactionUnsupportedInterceptor();
        this.prevaylerInterceptor = new PrevaylerInterceptor(useIdentification);
        if (useIdentification) {
            this.registerObjectInterceptor = new RegisterObjectInterceptor();
        }
    }

    public void advise(AspectInstance aspectInstance) {
        this.transactionUnsupportedPointcut.advise(aspectInstance, (MethodInterceptor)this.unsupportedInterceptor);
        this.transactionPointcut.advise(aspectInstance, (MethodInterceptor)this.checkUnsupportedInterceptor);
        this.transactionPointcut.advise(aspectInstance, (MethodInterceptor)this.prevaylerInterceptor);
        if (this.registerObjectInterceptor != null && PrevaylerUtils.isEntity(aspectInstance.getClassIdentifier())) {
            aspectInstance.addConstructionInterceptor((ConstructionInterceptor)this.registerObjectInterceptor);
        }
    }

    public void introduce(AspectInstance aspectInstance) {
    }
}

