/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.nanning.prevayler;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.util.Date;
import java.util.HashSet;
import org.codehaus.nanning.Aspects;
import org.codehaus.nanning.prevayler.CurrentPrevayler;
import org.codehaus.nanning.prevayler.IdentifyingSystem;
import org.codehaus.nanning.prevayler.Identity;
import org.codehaus.nanning.prevayler.Marshaller;
import org.codehaus.nanning.prevayler.ObjectGraphVisitor;
import org.codehaus.nanning.prevayler.PrevaylerUtils;

public class IdentifyingMarshaller
implements Marshaller,
Serializable {
    static final long serialVersionUID = 7285806267400465332L;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$codehaus$nanning$prevayler$IdentifyingMarshaller;

    public Object marshal(Object o) {
        if (PrevaylerUtils.isPrimitive(o)) {
            return o;
        }
        if (PrevaylerUtils.isStatefulService(o.getClass())) {
            if (!$assertionsDisabled && !(o instanceof Serializable)) {
                throw new AssertionError((Object)"Stateful services must be serializable");
            }
            return o;
        }
        if (PrevaylerUtils.isStatelessService(o.getClass())) {
            return new Identity(o.getClass(), Aspects.getAspectInstance((Object)o).getClassIdentifier());
        }
        if (PrevaylerUtils.isEntity(o.getClass())) {
            if (this.getSystem().hasObjectID(o)) {
                return new Identity(Aspects.getAspectInstance((Object)o).getClassIdentifier(), new Long(this.getSystem().getObjectID(o)));
            }
            return o;
        }
        return o;
    }

    public Object unmarshal(Object o) {
        if (PrevaylerUtils.isPrimitive(o)) {
            return o;
        }
        if (o instanceof Identity) {
            return this.resolve((Identity)o);
        }
        if (PrevaylerUtils.isEntity(o.getClass())) {
            if (!this.getSystem().hasObjectID(o)) {
                this.registerObjectIDsRecursive(o);
            }
            return o;
        }
        return o;
    }

    private IdentifyingSystem getSystem() {
        Object system = CurrentPrevayler.getSystem();
        if (!$assertionsDisabled && !(system instanceof IdentifyingSystem)) {
            throw new AssertionError((Object)"I need an identifying system to work");
        }
        return (IdentifyingSystem)system;
    }

    private Object resolve(Identity identity) {
        Class objectClass = identity.getObjectClass();
        if (PrevaylerUtils.isStatelessService(objectClass)) {
            return Aspects.getCurrentAspectFactory().newInstance((Class)identity.getIdentifier());
        }
        if (PrevaylerUtils.isEntity(objectClass)) {
            long oid = (Long)identity.getIdentifier();
            if (!$assertionsDisabled && !this.getSystem().isIDRegistered(oid)) {
                throw new AssertionError((Object)("object of type " + Aspects.getRealClass((Class)objectClass) + " had invalid object id " + oid));
            }
            return this.getSystem().getObjectWithID(oid);
        }
        throw new IllegalArgumentException("Can't resolve objects of " + objectClass);
    }

    private void registerObjectIDsRecursive(final Object objectToRegister) {
        final IdentifyingSystem system = this.getSystem();
        final HashSet registeredObjects = new HashSet();
        ObjectGraphVisitor.visit(objectToRegister, new ObjectGraphVisitor(){
            static final /* synthetic */ boolean $assertionsDisabled;

            protected void visit(Object o) {
                if (o instanceof AccessibleObject) {
                    return;
                }
                if (o instanceof Date) {
                    return;
                }
                if (PrevaylerUtils.isPrimitive(o)) {
                    return;
                }
                if (!registeredObjects.contains(o) && PrevaylerUtils.isEntity(o.getClass())) {
                    if (!$assertionsDisabled && system.hasObjectID(o)) {
                        throw new AssertionError((Object)("you're mixing objects in prevayler with objects outside, this will lead to unpredictable results, so I've banished that sort of behaviour with this assert here(the object that was inside prevayler was " + o + " the object that was outside was " + objectToRegister + ")"));
                    }
                    system.registerObjectID(o);
                    registeredObjects.add(o);
                }
                if (Aspects.isAspectObject((Object)o)) {
                    Object[] targets = Aspects.getTargets((Object)o);
                    int i = 0;
                    while (i < targets.length) {
                        super.visit(targets[i]);
                        ++i;
                    }
                } else {
                    super.visit(o);
                }
            }

            static {
                $assertionsDisabled = !(class$org$codehaus$nanning$prevayler$IdentifyingMarshaller == null ? (class$org$codehaus$nanning$prevayler$IdentifyingMarshaller = IdentifyingMarshaller.class$("org.codehaus.nanning.prevayler.IdentifyingMarshaller")) : class$org$codehaus$nanning$prevayler$IdentifyingMarshaller).desiredAssertionStatus();
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$org$codehaus$nanning$prevayler$IdentifyingMarshaller == null ? (class$org$codehaus$nanning$prevayler$IdentifyingMarshaller = IdentifyingMarshaller.class$("org.codehaus.nanning.prevayler.IdentifyingMarshaller")) : class$org$codehaus$nanning$prevayler$IdentifyingMarshaller).desiredAssertionStatus();
    }
}

